/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;

public class CatchClause
extends ASTObject {
    protected FormalDec formal;
    protected Stmt body;

    public void preScope(ScopeWalker walker) {
        walker.pushBlock();
    }

    public ASTObject postScope(ScopeWalker walker) {
        walker.popBlock();
        return this;
    }

    public void checkSpec() {
        NameType throwableType;
        Type exnType = this.formal.getType();
        if (!exnType.isSubtypeOf(throwableType = this.getTypeManager().getThrowableType())) {
            this.formal.getTypeD().showTypeError(exnType, throwableType);
        }
        this.body.requireBlockStmt();
    }

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("catch");
        writer.optionalSpace();
        writer.write('(');
        writer.write(this.formal);
        writer.write(')');
        writer.optionalSpace();
        writer.write(this.body);
    }

    public void walkFrameLoc(FrameLocPass walker) {
        int start = walker.getfs();
        super.walkFrameLoc(walker);
        walker.setfs(start);
    }

    public FormalDec getFormal() {
        return this.formal;
    }

    public void setFormal(FormalDec _formal) {
        if (_formal != null) {
            _formal.setParent(this);
        }
        this.formal = _formal;
    }

    public Stmt getBody() {
        return this.body;
    }

    public void setBody(Stmt _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public CatchClause(SourceLocation location, FormalDec _formal, Stmt _body) {
        super(location);
        this.setFormal(_formal);
        this.setBody(_body);
    }

    protected CatchClause(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        CatchClause ret = new CatchClause(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.formal != null) {
            ret.setFormal((FormalDec)walker.process(this.formal));
        }
        if (this.body != null) {
            ret.setBody((Stmt)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.formal;
            }
            case 1: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "formal";
            }
            case 1: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setFormal((FormalDec)child);
                return;
            }
            case 1: {
                this.setBody((Stmt)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "CatchClause()";
    }
}

