/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.EqualityTestOpExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public final class BooleanType
extends PrimitiveType {
    public String getName() {
        return "boolean";
    }

    public int getTypeIndex() {
        return 4;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Boolean");
    }

    public Expr getNullExpr() {
        return this.getAST().makeLiteral(false);
    }

    public String getDescriptor() {
        return "Z";
    }

    public BooleanType(JavaCompiler compiler) {
        super(compiler);
    }

    final LiteralExpr foldPlusOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldMinusOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldBitNotOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldAddOp(LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldNumericOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldShiftOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldNumericTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    LiteralExpr foldLogNotOp(LiteralExpr rand) {
        return this.getAST().makeLiteral(!rand.getBooleanValue());
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return this.getAST().makeLiteral(rand.getBooleanValue());
    }

    LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        boolean a = lit1.getBooleanValue();
        boolean b = lit2.getBooleanValue();
        if (op == "==") {
            return ast.makeLiteral(a == b);
        }
        if (op == "!=") {
            return ast.makeLiteral(a != b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldBitwiseOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        boolean a = lit1.getBooleanValue();
        boolean b = lit2.getBooleanValue();
        if (op == "&") {
            return ast.makeLiteral(a & b);
        }
        if (op == "|") {
            return ast.makeLiteral(a | b);
        }
        if (op == "^") {
            return ast.makeLiteral(a ^ b);
        }
        throw new RuntimeException("bad bitwise op " + op);
    }

    final void emitCast(CodeBuilder cb, Type castTo) {
    }

    final void emitLogNot(CodeBuilder cb) {
        cb.emitIntConstant(1);
        cb.emitIXOR();
    }

    final void emitAload(CodeBuilder cb) {
        cb.emitBALOAD();
    }

    final void emitAstore(CodeBuilder cb) {
        cb.emitBASTORE();
    }

    public final void emitLoad(CodeBuilder cb, int loc) {
        cb.emitILOAD(loc);
    }

    public final void emitStore(CodeBuilder cb, int loc) {
        cb.emitISTORE(loc);
    }

    public final void emitReturn(CodeBuilder cb) {
        cb.emitIRETURN();
    }

    void emitEqualityCompare(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "==") {
            cb.emitIF_ICMPEQ(t, f);
        } else if (op == "!=") {
            cb.emitIF_ICMPNE(t, f);
        }
    }

    void emitBitwiseOp(CodeBuilder cb, String op) {
        if (op == "&") {
            cb.emitIAND();
        } else if (op == "|") {
            cb.emitIOR();
        } else if (op == "^") {
            cb.emitIXOR();
        }
    }

    final void emitZero(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitOne(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitMinusOne(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitAdd(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitBitNot(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitNumericOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitShiftOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitNeg(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitNumericCompare(CodeBuilder cb, String op, Label t, Label f) {
        this.unsupportedEmit();
    }

    boolean hasFastEqualityTestOp() {
        return true;
    }

    void emitFastEqualityTestOp(CodeBuilder cb, EqualityTestOpExpr e, Label t, Label f) {
        Expr rand1 = e.getRand1();
        Expr rand2 = e.getRand2();
        String op = e.getOp();
        if (rand1 instanceof LiteralExpr) {
            if (rand1.isConstantTrue() ^ op != "==") {
                rand2.cgTest(cb, t, f);
            } else {
                rand2.cgTest(cb, f, t);
            }
        } else if (rand2 instanceof LiteralExpr) {
            if (rand2.isConstantTrue() ^ op != "==") {
                rand1.cgTest(cb, t, f);
            } else {
                rand1.cgTest(cb, f, t);
            }
        } else {
            rand1.cgValue(cb, this);
            rand2.cgValue(cb, this);
            this.emitEqualityCompare(cb, op, t, f);
        }
    }
}

