/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.BooleanType;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntegralType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class BitwiseAssignExpr
extends AssignExpr {
    public Type discoverType() {
        Type ty1 = this.lhs.getType();
        Type ty2 = this.rhs.getType();
        if (!(ty1 instanceof IntegralType && ty2 instanceof IntegralType || ty1 instanceof BooleanType && ty2 instanceof BooleanType)) {
            this.showOperatorTypeError(this.op, ty1, ty2);
        }
        return ty1;
    }

    public void walkFlow(FlowCheckerPass w) {
        super.walkFlow(w);
        if (this.getType().isBoolean()) {
            w.setVars(w.getVars().getTrue().join(w.getVars().getFalse()));
        }
    }

    protected void cgValue(CodeBuilder cb) {
        this.cgValueEffect(cb, true);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValueEffect(cb, false);
    }

    private void cgValueEffect(CodeBuilder cb, boolean needsValue) {
        AssignableExpr lhs = this.getLhs();
        Expr rhs = this.getRhs();
        Type lhsTy = lhs.getType();
        Type rhsTy = rhs.getType();
        String op = this.getOp();
        Type ty = lhsTy instanceof BooleanType ? lhsTy : this.getTypeManager().binaryNumericPromotion(lhsTy, rhsTy);
        lhs.cgLvalue(cb);
        lhs.cgDupLvalue(cb);
        lhs.cgLtoRvalue(cb);
        lhsTy.emitCast(cb, ty);
        rhs.cgValue(cb, ty);
        ty.emitBitwiseOp(cb, op);
        ty.emitCast(cb, lhsTy);
        if (needsValue) {
            lhs.cgDupRvalue(cb);
        }
        lhs.cgAssignment(cb);
    }

    public BitwiseAssignExpr(SourceLocation location, AssignableExpr _lhs, String _op, Expr _rhs) {
        super(location, _lhs, _op, _rhs);
    }

    protected BitwiseAssignExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        BitwiseAssignExpr ret = new BitwiseAssignExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.lhs != null) {
            ret.setLhs((AssignableExpr)walker.process(this.lhs));
        }
        ret.op = this.op;
        if (this.rhs != null) {
            ret.setRhs((Expr)walker.process(this.rhs));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "BitwiseAssignExpr(op: " + this.op + ")";
    }
}

