/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.IfStmt;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TestStmt;
import org.aspectj.compiler.base.ast.Type;

public class AssertStmt
extends TestStmt {
    protected Expr test;
    protected Expr message;

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("assert");
        writer.requiredSpace();
        writer.write(this.test);
        if (this.getMessage() != null) {
            writer.optionalSpace();
            writer.write(":");
            writer.optionalSpace();
            writer.write(this.getMessage());
        }
        writer.closeStmt();
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        if (!this.getCompiler().willGenerateSourceCode()) {
            return this.deSugar();
        }
        if (this.getOutermostLexicalType() == this.getOutermostBytecodeType()) {
            return this;
        }
        if (this.getLexicalType().isEffectivelyStatic()) {
            return this.deSugar();
        }
        this.showWarning("compiler limitation: this assert will behave as if inside " + this.getOutermostBytecodeType().toShortString());
        return this;
    }

    private ASTObject deSugar() {
        AST ast = this.getAST();
        Field adf = this.getLexicalType().getTypeDec().getAssertionsDisabledField();
        Type assertionErrorType = this.getTypeManager().getType("java.lang", "AssertionError");
        Exprs args = ast.makeExprs();
        if (this.message != null) {
            Expr e = this.message;
            if (e.getType().isReferenceType()) {
                e = ast.forceCast(this.getTypeManager().getObjectType(), e);
            }
            args.add(e);
        }
        IfStmt ret = ast.makeIf(ast.makeUnop("!", ast.makeParen(this.test)), ast.makeThrow(ast.makeNew(assertionErrorType, args)));
        ret = ast.makeIf(ast.makeUnop("!", ast.makeGet(adf)), ret);
        return ret;
    }

    public void walkFlow(FlowCheckerPass w) {
        FlowCheckerPass.Vars v0 = w.getVars();
        w.process(this.getTest());
        if (this.getMessage() != null) {
            w.process(this.getMessage());
        }
        FlowCheckerPass.Vars v1 = w.getVars();
        w.setVars(v0);
    }

    public Expr getTest() {
        return this.test;
    }

    public void setTest(Expr _test) {
        if (_test != null) {
            _test.setParent(this);
        }
        this.test = _test;
    }

    public Expr getMessage() {
        return this.message;
    }

    public void setMessage(Expr _message) {
        if (_message != null) {
            _message.setParent(this);
        }
        this.message = _message;
    }

    public AssertStmt(SourceLocation location, Expr _test, Expr _message) {
        super(location);
        this.setTest(_test);
        this.setMessage(_message);
    }

    protected AssertStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AssertStmt ret = new AssertStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.test != null) {
            ret.setTest((Expr)walker.process(this.test));
        }
        if (this.message != null) {
            ret.setMessage((Expr)walker.process(this.message));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.test;
            }
            case 1: {
                return this.message;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "test";
            }
            case 1: {
                return "message";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTest((Expr)child);
                return;
            }
            case 1: {
                this.setMessage((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "AssertStmt()";
    }
}

