/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;

public class ArrayTypeD
extends TypeD {
    protected TypeD componentTypeD;

    public String getString() {
        return this.componentTypeD.getString() + "[]";
    }

    public String toShortString() {
        return this.componentTypeD.toShortString() + "[]";
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.componentTypeD);
        writer.write("[]");
    }

    public void checkSpec() {
        if (this.componentTypeD.getType().isVoid()) {
            this.showError("can't have an array of void");
        } else {
            super.checkSpec();
        }
    }

    public Type getType() {
        return this.componentTypeD.getType().getArrayType();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArrayTypeD)) {
            return false;
        }
        return this.componentTypeD.equals(((ArrayTypeD)other).getComponentTypeD());
    }

    public TypeD getComponentTypeD() {
        return this.componentTypeD;
    }

    public void setComponentTypeD(TypeD _componentTypeD) {
        if (_componentTypeD != null) {
            _componentTypeD.setParent(this);
        }
        this.componentTypeD = _componentTypeD;
    }

    public ArrayTypeD(SourceLocation location, TypeD _componentTypeD) {
        super(location);
        this.setComponentTypeD(_componentTypeD);
    }

    protected ArrayTypeD(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ArrayTypeD ret = new ArrayTypeD(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.componentTypeD != null) {
            ret.setComponentTypeD((TypeD)walker.process(this.componentTypeD));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.componentTypeD;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "componentTypeD";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setComponentTypeD((TypeD)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ArrayTypeD()";
    }
}

