/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.NullType;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ArrayType
extends RefType {
    private Type componentType;
    private int arrayDimCount;
    private final FieldDec lengthFieldDec;
    private final Field lengthField;
    private final MethodDec cloneMethodDec;
    private final Method cloneMethod;
    private String externalName;
    private String internalName;
    private String descriptor;

    public ArrayType(JavaCompiler compiler, Type componentType) {
        super(compiler);
        this.lengthFieldDec = this.getAST().makeField(this.getAST().makeModifiers(1), this.getTypeManager().intType, "length", null);
        this.lengthFieldDec.setAllEnclosingTypes(this);
        this.lengthField = (Field)this.lengthFieldDec.getCorrespondingSemanticObject();
        this.cloneMethodDec = this.getAST().makeMethod(this.getAST().makeModifiers(1), this.getTypeManager().getObjectType(), "clone", this.getAST().makeFormals(), null);
        this.cloneMethodDec.setAllEnclosingTypes(this);
        this.cloneMethod = (Method)this.cloneMethodDec.getCorrespondingSemanticObject();
        this.addDirectSuperType(this.getTypeManager().getObjectType());
        this.componentType = componentType;
        this.arrayDimCount = 1 + componentType.getArrayDimCount();
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public int getArrayDimCount() {
        return this.arrayDimCount;
    }

    public Type getBaseComponentType() {
        return this.getComponentType().getBaseComponentType();
    }

    public Expr getClassExpr() {
        return this.getAST().makeLiteral(this);
    }

    public Expr fromObject(Expr expr) {
        return this.getAST().makeCast(this, expr);
    }

    public Expr makeObject(Expr expr) {
        return expr;
    }

    public Expr getNullExpr() {
        return this.getAST().makeNull();
    }

    public Type getRefType() {
        return this;
    }

    boolean checkAccess(ASTObject fromWhere, boolean showError) {
        if (this.isAccessible(fromWhere)) {
            return true;
        }
        if (showError) {
            fromWhere.showError("array " + this.getPrettyString() + " is not accessible here");
        }
        return false;
    }

    public Field getField(String id, ASTObject fromWhere, boolean showError) {
        if (id.equals("length")) {
            if (!this.checkAccess(fromWhere, showError)) {
                return null;
            }
            return this.lengthField;
        }
        if (showError) {
            this.getCompiler().showError(fromWhere, "no field " + id + " on arrays");
        }
        return null;
    }

    public Method getMethod(String id, ASTObject fromWhere, Exprs params, boolean showError) {
        if (!this.checkAccess(fromWhere, showError)) {
            return null;
        }
        if (id.equals("clone") && params.size() == 0) {
            return this.cloneMethod;
        }
        return this.getTypeManager().getObjectType().getMethod(id, fromWhere, params, showError);
    }

    public SemanticObject findMatchingSemanticObject(SemanticObject o) {
        if (o == this.cloneMethod) {
            return this.cloneMethod;
        }
        if (o == this.lengthField) {
            return this.lengthField;
        }
        return this.getTypeManager().getObjectType().findMatchingSemanticObject(o);
    }

    public String getString() {
        return this.componentType.getString() + "[]";
    }

    public String toShortString() {
        return this.componentType.toShortString() + "[]";
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.componentType.getString());
        writer.write("[]");
    }

    public boolean isEquivalent(Type _other) {
        if (!(_other instanceof ArrayType)) {
            return false;
        }
        return ((ArrayType)_other).componentType.isEquivalent(this.componentType);
    }

    public boolean isSubtypeOf(Type other) {
        return other.isObject() || other == this.getTypeManager().getCloneableType() || other == this.getTypeManager().getSerializableType();
    }

    public boolean isAssignableFrom(Type _other) {
        if (_other.isAnyType()) {
            return true;
        }
        if (_other instanceof NullType) {
            return true;
        }
        if (!(_other instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)_other;
        if (this.isEquivalent(other)) {
            return true;
        }
        if (this.componentType.isReferenceType() && other.getComponentType().isReferenceType()) {
            return this.componentType.isAssignableFrom(other.getComponentType());
        }
        return false;
    }

    public boolean isCoercableTo(Type _other) {
        if (_other.isAssignableFrom(this)) {
            return true;
        }
        if (this.isAssignableFrom(_other)) {
            return true;
        }
        if (!(_other instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)_other;
        if (this.isEquivalent(other)) {
            return true;
        }
        if (this.componentType.isReferenceType() && other.getComponentType().isReferenceType()) {
            return this.componentType.isCoercableTo(other.getComponentType());
        }
        return false;
    }

    public boolean isCloneable() {
        return true;
    }

    void emitMultiNewarray(CodeBuilder cb, int filledDims) {
        cb.emitMULTIANEWARRAY(this, filledDims);
    }

    public synchronized String getExternalName() {
        if (this.externalName == null) {
            this.externalName = this.getDescriptor().replace('/', '.');
        }
        return this.externalName;
    }

    public String getInternalName() {
        return this.getDescriptor();
    }

    public synchronized String getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = "[" + this.getComponentType().getDescriptor();
        }
        return this.descriptor;
    }
}

