/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class AddAssignExpr
extends AssignExpr {
    public Type discoverType() {
        Type ty1 = this.lhs.getType();
        Type ty2 = this.rhs.getType();
        if (!(ty1.isString() && !ty2.isVoid() || ty1 instanceof NumericType && ty2 instanceof NumericType)) {
            this.showOperatorTypeError(this.op, ty1, ty2);
        }
        return ty1;
    }

    protected void cgValue(CodeBuilder cb) {
        this.cgValueEffect(cb, true);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValueEffect(cb, false);
    }

    private void cgValueEffect(CodeBuilder cb, boolean needsValue) {
        AssignableExpr lhs = this.getLhs();
        Expr rhs = this.getRhs();
        Type lhsTy = lhs.getType();
        if (lhsTy.isString()) {
            NameType stringBufferType = this.getTypeManager().getStringBufferType();
            lhs.cgLvalue(cb);
            lhs.cgDupLvalue(cb);
            lhs.cgLtoRvalue(cb);
            cb.emitNEW(stringBufferType);
            cb.emitDUP();
            cb.emitINVOKESPECIAL(stringBufferType, "<init>", "()V", -1);
            cb.emitSWAP();
            cb.emitINVOKEVIRTUAL(stringBufferType, "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;", -1);
            rhs.cgBuffer(cb);
            cb.emitINVOKEVIRTUAL(stringBufferType, "toString", "()Ljava/lang/String;", 0);
            if (needsValue) {
                lhs.cgDupRvalue(cb);
            }
            lhs.cgAssignment(cb);
        } else if (rhs instanceof IntLiteralExpr && lhsTy.hasFastIncOp(lhs, ((IntLiteralExpr)rhs).getIntValue())) {
            lhsTy.emitFastIncOp(cb, lhs, ((IntLiteralExpr)rhs).getIntValue());
            if (needsValue) {
                lhs.cgValue(cb);
            }
        } else {
            Type rhsTy = rhs.getType();
            Type ty = this.getTypeManager().binaryNumericPromotion(lhsTy, rhsTy);
            lhs.cgLvalue(cb);
            lhs.cgDupLvalue(cb);
            lhs.cgLtoRvalue(cb);
            lhsTy.emitCast(cb, ty);
            rhs.cgValue(cb, ty);
            ty.emitAdd(cb);
            ty.emitCast(cb, lhsTy);
            if (needsValue) {
                lhs.cgDupRvalue(cb);
            }
            lhs.cgAssignment(cb);
        }
    }

    public AddAssignExpr(SourceLocation location, AssignableExpr _lhs, String _op, Expr _rhs) {
        super(location, _lhs, _op, _rhs);
    }

    protected AddAssignExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        AddAssignExpr ret = new AddAssignExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.lhs != null) {
            ret.setLhs((AssignableExpr)walker.process(this.lhs));
        }
        ret.op = this.op;
        if (this.rhs != null) {
            ret.setRhs((Expr)walker.process(this.rhs));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "AddAssignExpr(op: " + this.op + ")";
    }
}

