/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayExpr;
import org.aspectj.compiler.base.ast.ArrayInitializer;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.BooleanLiteralExpr;
import org.aspectj.compiler.base.ast.BreakStmt;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CastExpr;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CatchClauses;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorBody;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.ContinueStmt;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.DoubleLiteralExpr;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.ExprStmt;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FloatLiteralExpr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.IfStmt;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.InstanceofExpr;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.LabeledStmt;
import org.aspectj.compiler.base.ast.LogNotOpExpr;
import org.aspectj.compiler.base.ast.LongLiteralExpr;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.NewArrayExpr;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.NullExpr;
import org.aspectj.compiler.base.ast.NullType;
import org.aspectj.compiler.base.ast.ParenExpr;
import org.aspectj.compiler.base.ast.PostfixExpr;
import org.aspectj.compiler.base.ast.PrefixExpr;
import org.aspectj.compiler.base.ast.QualifiedThisExpr;
import org.aspectj.compiler.base.ast.ResolvedTypeD;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.StringLiteralExpr;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.ThrowStmt;
import org.aspectj.compiler.base.ast.TriTestExpr;
import org.aspectj.compiler.base.ast.TryCatchStmt;
import org.aspectj.compiler.base.ast.TryFinallyStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.TypeExpr;
import org.aspectj.compiler.base.ast.UnopExpr;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.WhileStmt;
import org.aspectj.compiler.crosscuts.ast.AnonymousMethodExpr;

public class AST
extends CompilerObject {
    private SourceLocation sourceLocation;
    public static final String PREFIX = "aspectj$";

    public AST(SourceLocation location) {
        super(location.getCompiler());
        this.sourceLocation = location;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    private static String makeLegalIdentifier(String s) {
        if (s.length() == 0) {
            return "_";
        }
        char[] chars = s.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            chars[0] = 95;
        }
        int i = 1;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
            }
            ++i;
        }
        return new String(chars);
    }

    public String makeGeneratedName(String s) {
        s = AST.makeLegalIdentifier(s);
        if (this.getOptions().XaddSafePrefix) {
            if (s.startsWith(PREFIX)) {
                return s;
            }
            return PREFIX + s;
        }
        return s;
    }

    public StringLiteralExpr makeString(String s) {
        return new StringLiteralExpr(this.getSourceLocation(), s);
    }

    public CallExpr makeStaticCall(MethodDec method, Exprs args) {
        return this.makeStaticCall(method.getMethod(), args);
    }

    public CallExpr makeStaticCall(MethodDec dec, Expr a1) {
        return this.makeStaticCall(dec.getMethod(), a1);
    }

    public CallExpr makeStaticCall(Method method, Exprs args) {
        return new CallExpr(this.getSourceLocation(), method, this.makeTypeExpr(method.getDeclaringType()), args);
    }

    public CallExpr makeStaticCall(Method dec, Expr a1) {
        return this.makeStaticCall(dec, this.makeExprs(a1));
    }

    public CallExpr makeStaticCall(Type type, String name, Exprs args) {
        return new CallExpr(this.getSourceLocation(), type.getMethod(name, null, args, true), this.makeTypeExpr(type), args);
    }

    public CallExpr makeStaticCall(Type type, String name) {
        return this.makeStaticCall(type, name, new Exprs(this.getSourceLocation()));
    }

    public CallExpr makeStaticCall(Type type, String name, Expr a1) {
        return this.makeStaticCall(type, name, new Exprs(this.getSourceLocation(), a1));
    }

    public CallExpr makeStaticCall(Type type, String name, Expr a1, Expr a2) {
        return this.makeStaticCall(type, name, new Exprs(this.getSourceLocation(), a1, a2));
    }

    public CallExpr makeStaticCall(Type type, String name, Expr a1, Expr a2, Expr a3) {
        return this.makeStaticCall(type, name, new Exprs(this.getSourceLocation(), a1, a2, a3));
    }

    public CallExpr makeStaticCall(Type type, String name, Expr a1, Expr a2, Expr a3, Expr a4) {
        return this.makeStaticCall(type, name, this.makeExprs(a1, a2, a3, a4));
    }

    public CallExpr makeStaticCall(Type type, String name, Expr a1, Expr a2, Expr a3, Expr a4, Expr a5) {
        return this.makeStaticCall(type, name, this.makeExprs(a1, a2, a3, a4, a5));
    }

    public CallExpr makeStaticCall(Type type, String name, Expr a1, Expr a2, Expr a3, Expr a4, Expr a5, Expr a6) {
        return this.makeStaticCall(type, name, this.makeExprs(a1, a2, a3, a4, a5, a6));
    }

    public CallExpr makeStaticCall(Type type, String name, Expr a1, Expr a2, Expr a3, Expr a4, Expr a5, Expr a6, Expr a7) {
        return this.makeStaticCall(type, name, this.makeExprs(a1, a2, a3, a4, a5, a6, a7));
    }

    public NewInstanceExpr makeNew(Type type, Exprs args, Constructor constructor) {
        return new NewInstanceExpr(this.getSourceLocation(), null, type.makeTypeD(), args, null, constructor);
    }

    public NewInstanceExpr makeNew(Type type, Exprs args) {
        return new NewInstanceExpr(this.getSourceLocation(), type.getConstructor(null, args, true), args);
    }

    public NewInstanceExpr makeNew(Type type) {
        return this.makeNew(type, new Exprs(this.getSourceLocation()));
    }

    public NewInstanceExpr makeNew(Type type, Expr a1) {
        return this.makeNew(type, new Exprs(this.getSourceLocation(), a1));
    }

    public NewInstanceExpr makeNew(Type type, Expr a1, Expr a2) {
        return this.makeNew(type, new Exprs(this.getSourceLocation(), a1, a2));
    }

    public NewArrayExpr makeNewArray(ArrayType type, ArrayInitializer init) {
        return new NewArrayExpr(this.getSourceLocation(), type.makeTypeD(), init, null);
    }

    public ConstructorCallExpr makeQualifiedConstructorCall(Exprs args, Constructor constructor, Expr primary) {
        return new ConstructorCallExpr(this.getSourceLocation(), primary, true, args, constructor);
    }

    public ConstructorCallExpr makeConstructorCall(boolean isSuper, Exprs args, Constructor constructor) {
        return new ConstructorCallExpr(this.getSourceLocation(), isSuper, args, constructor);
    }

    public ConstructorCallExpr makeSuperConstructorCall(Exprs args, Constructor constructor) {
        return this.makeConstructorCall(true, args, constructor);
    }

    public ConstructorCallExpr makeSuperConstructorCall(Constructor constructor) {
        return this.makeConstructorCall(true, this.makeExprs(), constructor);
    }

    public ConstructorBody makeConstructorBody(ConstructorCallExpr c, Stmts s) {
        return new ConstructorBody(this.getSourceLocation(), s, true, c);
    }

    public ConstructorDec makeConstructor(Modifiers m, Formals f, TypeDs ts, ConstructorCallExpr c, Stmts s) {
        return new ConstructorDec(this.getSourceLocation(), m, f, ts, this.makeConstructorBody(c, s));
    }

    public CallExpr makeCall(Expr instance, String name, Exprs args) {
        return new CallExpr(this.getSourceLocation(), instance.getType().getMethod(name, null, args, true), instance, args);
    }

    public CallExpr makeCall(Expr instance, String name) {
        return this.makeCall(instance, name, new Exprs(this.getSourceLocation()));
    }

    public CallExpr makeCall(Expr instance, String name, Expr a1) {
        return this.makeCall(instance, name, new Exprs(this.getSourceLocation(), a1));
    }

    public CallExpr makeCall(Expr instance, String name, Expr a1, Expr a2) {
        return this.makeCall(instance, name, new Exprs(this.getSourceLocation(), a1, a2));
    }

    public CallExpr makeCall(Method md, Expr instance, Exprs args) {
        if (instance == null) {
            md.getMethodDec().showError("INTERNAL: instance null in call to");
        }
        return new CallExpr(this.getSourceLocation(), md, instance, args);
    }

    public CallExpr makeCall(Method md, Expr instance) {
        return this.makeCall(md, instance, new Exprs(this.getSourceLocation()));
    }

    public CallExpr makeCall(Method md, Expr instance, Expr a1) {
        return this.makeCall(md, instance, new Exprs(this.getSourceLocation(), a1));
    }

    public CallExpr makeCall(Method md, Expr instance, Expr a1, Expr a2) {
        return this.makeCall(md, instance, new Exprs(this.getSourceLocation(), a1, a2));
    }

    public CallExpr makeCall(MethodDec md, Expr instance, Exprs args) {
        if (instance == null) {
            md.showError("INTERNAL: instance null in call to");
        }
        return new CallExpr(this.getSourceLocation(), md.getMethod(), instance, args);
    }

    public CallExpr makeCall(MethodDec md, Expr instance) {
        return this.makeCall(md, instance, new Exprs(this.getSourceLocation()));
    }

    public CallExpr makeCall(MethodDec md, Expr instance, Expr a1) {
        return this.makeCall(md, instance, new Exprs(this.getSourceLocation(), a1));
    }

    public CallExpr makeCall(MethodDec md, Expr instance, Expr a1, Expr a2) {
        return this.makeCall(md, instance, new Exprs(this.getSourceLocation(), a1, a2));
    }

    public CallExpr makeSuperCall(Method md, Exprs args) {
        return new CallExpr(this.getSourceLocation(), this.makeThis(md.getDeclaringType()), md.getName(), args, md, true);
    }

    public LogNotOpExpr makeLogNot(Expr arg) {
        return new LogNotOpExpr(this.getSourceLocation(), "!", arg);
    }

    public Exprs makeExprs() {
        Exprs exprs = new Exprs(this.getSourceLocation());
        return exprs;
    }

    public Exprs makeExprs(Expr a1) {
        Exprs exprs = new Exprs(this.getSourceLocation(), a1);
        return exprs;
    }

    public Exprs makeExprs(Expr a1, Expr a2) {
        Exprs exprs = new Exprs(this.getSourceLocation(), a1, a2);
        return exprs;
    }

    public Exprs makeExprs(Expr a1, Expr a2, Expr a3) {
        Exprs exprs = new Exprs(this.getSourceLocation(), a1, a2, a3);
        return exprs;
    }

    public Exprs makeExprs(Expr a1, Expr a2, Expr a3, Expr a4) {
        Exprs exprs = new Exprs(this.getSourceLocation());
        exprs.add(a1);
        exprs.add(a2);
        exprs.add(a3);
        exprs.add(a4);
        return exprs;
    }

    public Exprs makeExprs(Expr a1, Expr a2, Expr a3, Expr a4, Expr a5) {
        Exprs exprs = new Exprs(this.getSourceLocation());
        exprs.add(a1);
        exprs.add(a2);
        exprs.add(a3);
        exprs.add(a4);
        exprs.add(a5);
        return exprs;
    }

    public Exprs makeExprs(Expr a1, Expr a2, Expr a3, Expr a4, Expr a5, Expr a6) {
        Exprs exprs = new Exprs(this.getSourceLocation());
        exprs.add(a1);
        exprs.add(a2);
        exprs.add(a3);
        exprs.add(a4);
        exprs.add(a5);
        exprs.add(a6);
        return exprs;
    }

    public Exprs makeExprs(Expr a1, Expr a2, Expr a3, Expr a4, Expr a5, Expr a6, Expr a7) {
        Exprs exprs = new Exprs(this.getSourceLocation());
        exprs.add(a1);
        exprs.add(a2);
        exprs.add(a3);
        exprs.add(a4);
        exprs.add(a5);
        exprs.add(a6);
        exprs.add(a7);
        return exprs;
    }

    public TriTestExpr makeTriTest(Expr t, Expr c, Expr a) {
        return new TriTestExpr(this.getSourceLocation(), t, c, a);
    }

    public Stmt makeStmt(Expr expr) {
        return new ExprStmt(this.getSourceLocation(), expr);
    }

    public TriTestExpr makeIfExpr(Expr test, Expr trueValue, Expr falseValue) {
        return new TriTestExpr(this.getSourceLocation(), test, trueValue, falseValue);
    }

    public BinopExpr makeBinop(String op, Expr lhs, Expr rhs) {
        return BinopExpr.build(this.getSourceLocation(), op, lhs, rhs);
    }

    public UnopExpr makeUnop(String op, Expr lhs) {
        return UnopExpr.build(this.getSourceLocation(), op, lhs);
    }

    public FieldAccessExpr makeDynamicGet(FieldDec dec) {
        return this.makeGet((Expr)this.makeQualifiedThis(dec.getDeclaringType()), dec);
    }

    public FieldAccessExpr makeStaticGet(Type type, String name) {
        return new FieldAccessExpr(this.getSourceLocation(), this.makeTypeExpr(type), type.getField(name, null, true), false);
    }

    public Expr forceCast(Type toType, Expr expr) {
        CastExpr castExpr = new CastExpr(this.getSourceLocation(), toType.makeTypeD(), expr);
        if (!castExpr.isPossibleCast()) {
            expr.showError("can not be cast to " + toType.getString());
        }
        return this.makeParen(castExpr);
    }

    public Expr makeCast(Type toType, Expr expr) {
        Type exprType = expr.getType();
        if (exprType == expr.getTypeManager().anyType) {
            this.getCompiler().internalError(expr, "expr is anytype: " + expr);
        }
        if (exprType instanceof NullType) {
            return this.forceCast(toType, expr);
        }
        if (exprType.isEquivalent(toType) || toType.isAssignableFrom(exprType)) {
            if (expr instanceof CastExpr) {
                return this.makeParen(expr);
            }
            return expr;
        }
        return this.forceCast(toType, expr);
    }

    public Expr makeNotInstanceofTest(Expr expr, Type ofType) {
        if (expr.getType().isSubtypeOf(ofType)) {
            return this.makeLiteral(true);
        }
        return this.makeUnop("!", this.makeParen(this.makeInstanceof(expr, ofType)));
    }

    public Expr makeInstanceof(Expr expr, Type ofType) {
        return new InstanceofExpr(this.getSourceLocation(), expr, ofType.makeTypeD());
    }

    public ThisExpr makeThis(Type thisType) {
        return new ThisExpr(this.getSourceLocation(), thisType);
    }

    public QualifiedThisExpr makeQualifiedThis(TypeD typeD) {
        return new QualifiedThisExpr(this.getSourceLocation(), typeD);
    }

    public QualifiedThisExpr makeQualifiedThis(Type type) {
        return this.makeQualifiedThis(type.makeTypeD());
    }

    public TypeExpr makeTypeExpr(TypeD typeD) {
        return new TypeExpr(this.getSourceLocation(), typeD);
    }

    public TypeExpr makeTypeExpr(Type type) {
        return this.makeTypeExpr(type.makeTypeD());
    }

    public Expr makeNonNullTest(Expr expr) {
        return this.makeBinop("!=", expr, this.makeNull());
    }

    public Expr makeNullTest(Expr expr) {
        return this.makeBinop("==", expr, this.makeNull());
    }

    public BooleanLiteralExpr makeLiteral(boolean b) {
        return new BooleanLiteralExpr(this.getSourceLocation(), b);
    }

    public IntLiteralExpr makeLiteral(int i) {
        return new IntLiteralExpr(this.getSourceLocation(), i);
    }

    public LongLiteralExpr makeLiteral(long l) {
        return new LongLiteralExpr(this.getSourceLocation(), l);
    }

    public FloatLiteralExpr makeLiteral(float f) {
        return new FloatLiteralExpr(this.getSourceLocation(), f);
    }

    public DoubleLiteralExpr makeLiteral(double d) {
        return new DoubleLiteralExpr(this.getSourceLocation(), d);
    }

    public StringLiteralExpr makeLiteral(String s) {
        return new StringLiteralExpr(this.getSourceLocation(), s);
    }

    public Expr makeLiteral(Type type) {
        return type.getClassExpr();
    }

    public NullExpr makeNull() {
        return new NullExpr(this.getSourceLocation());
    }

    public Exprs makeVars(Formals formals) {
        return this.makeVars(formals, 0);
    }

    public Exprs makeVars(Formals formals, int i) {
        Exprs es = this.makeExprs();
        int len = formals.size();
        while (i < len) {
            es.add(this.makeVar(formals.get(i)));
            ++i;
        }
        return es;
    }

    public Expr makeNotFoundExpr() {
        return this.makeVar(this.makeVarDec(this.getTypeManager().TYPE_NOT_FOUND, "not_found", null));
    }

    public VarExpr makeVar(VarDec dec) {
        return new VarExpr(this.getSourceLocation(), dec);
    }

    public Expr makeParen(Expr expr) {
        return new ParenExpr(this.getSourceLocation(), expr);
    }

    public AssignExpr makeSet(AssignableExpr lhs, Expr rhs) {
        return AssignExpr.build(this.getSourceLocation(), lhs, "", rhs);
    }

    public AssignExpr makeSet(AssignableExpr lhs, String op, Expr rhs) {
        return AssignExpr.build(this.getSourceLocation(), lhs, op, rhs);
    }

    public AssignExpr makeSet(VarDec vd, Expr rhs) {
        return AssignExpr.build(this.getSourceLocation(), this.makeVar(vd), "", rhs);
    }

    public AssignExpr makeSet(FieldDec fd, Expr rhs) {
        return this.makeSet(fd.getField(), rhs);
    }

    public AssignExpr makeSet(Field fd, Expr rhs) {
        return AssignExpr.build(this.getSourceLocation(), this.makeGet(fd), "", rhs);
    }

    public AssignExpr makeSet(Expr i, Field field, Expr rhs) {
        return AssignExpr.build(this.getSourceLocation(), this.makeGet(i, field), "", rhs);
    }

    public AssignExpr makeSet(Expr i, FieldDec field, Expr rhs) {
        return this.makeSet(i, field.getField(), rhs);
    }

    public FieldAccessExpr makeGet(Expr i, FieldDec field) {
        return this.makeGet(i, field.getField());
    }

    public FieldAccessExpr makeGet(FieldDec field) {
        return this.makeGet(field.getField());
    }

    public FieldAccessExpr makeGet(Expr i, Field field) {
        if (i == null) {
            field.getFieldDec().showError("INTERNAL: instance null in get");
            return this.makeGet(field);
        }
        return new FieldAccessExpr(this.getSourceLocation(), i, field, false);
    }

    public PrefixExpr makePrefix(Expr i, FieldDec field, String op) {
        return new PrefixExpr(this.getSourceLocation(), this.makeGet(i, field), op);
    }

    public PostfixExpr makePostfix(Expr i, FieldDec field, String op) {
        return new PostfixExpr(this.getSourceLocation(), this.makeGet(i, field), op);
    }

    public Expr makePrimary(SemanticObject o, NameType referenceType) {
        NameType declaringType = (NameType)o.getDeclaringType();
        return this.makePrimary(declaringType, referenceType, o.isStatic());
    }

    public Expr makePrimary(SemanticObject o, TypeDec referenceDec) {
        NameType declaringType = (NameType)o.getDeclaringType();
        NameType referenceType = (NameType)referenceDec.getType();
        return this.makePrimary(declaringType, referenceType, o.isStatic());
    }

    public Expr makePrimary(Dec dec, TypeDec referenceDec) {
        NameType declaringType = (NameType)dec.getDeclaringType();
        NameType referenceType = (NameType)referenceDec.getType();
        return this.makePrimary(declaringType, referenceType, dec.isStatic());
    }

    public Expr makePrimary(Dec dec, NameType referenceType) {
        NameType declaringType = (NameType)dec.getDeclaringType();
        return this.makePrimary(declaringType, referenceType, dec.isStatic());
    }

    public Expr makePrimary(NameType declaring, NameType reference, boolean isStatic) {
        return this.makePrimary(declaring, reference, isStatic, true);
    }

    public Expr makePrimary(NameType declaring, NameType reference, boolean isStatic, boolean isThisAvailable) {
        if (reference.isSubtypeOf(declaring) && isStatic) {
            return this.makeTypeExpr(reference);
        }
        if (reference.isSubtypeOf(declaring) && isThisAvailable) {
            return this.makeThis(reference);
        }
        NameType curr = reference;
        while (!curr.isPackageMember()) {
            if (!(curr = curr.getEnclosingType()).isSubtypeOf(declaring)) continue;
            return isStatic ? this.makeTypeExpr(curr) : this.makeQualifiedThis(curr);
        }
        throw new RuntimeException("No enclosing type for " + declaring + " and " + reference);
    }

    public Expr makeEnclosingPrimary(NameType declaring, NameType reference) {
        NameType curr = reference;
        while (!curr.isPackageMember()) {
            if (!(curr = curr.getEnclosingType()).isSubtypeOf(declaring)) continue;
            return this.makeQualifiedThis(curr);
        }
        throw new RuntimeException("No enclosing type for " + declaring + " and " + reference);
    }

    public FieldAccessExpr makeGet(Field field) {
        return this.makeGet(field.isStatic() ? this.makeTypeExpr(field.getDeclaringType()) : this.makeThis(null), field);
    }

    public Decs makeDecs() {
        return new Decs(this.getSourceLocation());
    }

    public TypeDs makeTypeDs() {
        return new TypeDs(this.getSourceLocation());
    }

    public TypeDs makeTypeDs(TypeD ty0) {
        return new TypeDs(this.getSourceLocation(), ty0);
    }

    public NewArrayExpr makeArray(Type type, Exprs values) {
        return new NewArrayExpr(this.getSourceLocation(), new ResolvedTypeD(this.getSourceLocation(), type.getArrayType()), new ArrayInitializer(this.getSourceLocation(), values), null);
    }

    public NewArrayExpr makeObjectArray(Exprs values) {
        Exprs objectExprs = new Exprs(this.getSourceLocation());
        int i = 0;
        while (i < values.size()) {
            Expr value = values.get(i);
            objectExprs.add(value.getType().makeObject(value));
            ++i;
        }
        return this.makeArray(this.getTypeManager().getObjectType(), objectExprs);
    }

    public Modifiers makeModifiers(int value) {
        return new Modifiers(this.getSourceLocation(), value);
    }

    public FormalDec makeFormal(Type type, String id) {
        return this.makeFormal(type, id, false);
    }

    public FormalDec makeFinalFormal(Type type, String id) {
        return this.makeFormal(type, id, true);
    }

    public FormalDec makeFormal(Type type, String id, boolean isFinal) {
        return new FormalDec(this.getSourceLocation(), this.makeModifiers(isFinal ? 16 : 0), type.makeTypeD(), id, null);
    }

    public Formals makeFormals() {
        return new Formals(this.getSourceLocation());
    }

    public Formals makeFormals(FormalDec f1) {
        return new Formals(this.getSourceLocation(), f1);
    }

    public Formals makeFormals(FormalDec f1, FormalDec f2) {
        return new Formals(this.getSourceLocation(), f1, f2);
    }

    public VarDec makeVarDec(Modifiers mods, Type type, String id, Expr init) {
        return new VarDec(this.getSourceLocation(), mods, type.makeTypeD(), id, init);
    }

    public VarDec makeVarDec(Type type, String id, Expr init, boolean isFinal) {
        return new VarDec(this.getSourceLocation(), this.makeModifiers(isFinal ? 16 : 0), type.makeTypeD(), id, init);
    }

    public VarDec makeVarDec(Type type, String id, Expr init) {
        return new VarDec(this.getSourceLocation(), type.makeTypeD(), id, init);
    }

    public VarDec makeFinalVar(Type type, String id, Expr init) {
        return new VarDec(this.getSourceLocation(), this.makeModifiers(16), type.makeTypeD(), id, init);
    }

    public ArrayExpr makeArrayRef(Expr arrayExpr, int index) {
        return new ArrayExpr(this.getSourceLocation(), arrayExpr, this.makeLiteral(index));
    }

    public FieldDec makeField(Modifiers mods, Type type, String id) {
        return new FieldDec(this.getSourceLocation(), mods, type.makeTypeD(), id, null);
    }

    public FieldDec makeField(Modifiers mods, Type type, String id, Expr init) {
        return new FieldDec(this.getSourceLocation(), mods, type.makeTypeD(), id, init);
    }

    public InitializerDec makeInitializer(Stmts body) {
        return new InitializerDec(this.getSourceLocation(), this.makeModifiers(0), new CodeBody(this.getSourceLocation(), body, true));
    }

    public InitializerDec makeStaticInitializer(Stmts body) {
        return new InitializerDec(this.getSourceLocation(), this.makeModifiers(8), new CodeBody(this.getSourceLocation(), body, true));
    }

    public MethodDec makeMethod(Modifiers mods, Type retType, String name, Formals formals, BlockStmt body) {
        MethodDec ret = new MethodDec(this.getSourceLocation(), mods, retType.makeTypeD(), name, formals, null, body);
        ret.computeMinimalThrows();
        return ret;
    }

    public CodeBody makeCodeBody(Stmt s) {
        return new CodeBody(this.getSourceLocation(), this.makeStmts(s), true);
    }

    public CodeBody makeCodeBody(Stmt s0, Stmt s1) {
        return new CodeBody(this.getSourceLocation(), this.makeStmts(s0, s1), true);
    }

    public IfStmt makeIf(Expr test, Stmt trueStmt, Stmt falseStmt) {
        return new IfStmt(this.getSourceLocation(), test, trueStmt, falseStmt);
    }

    public IfStmt makeIf(Expr test, Stmt trueStmt) {
        IfStmt s = new IfStmt(this.getSourceLocation(), test, trueStmt, null);
        s.setElse(s.getAST().makeEmptyStmt());
        return s;
    }

    public TryFinallyStmt makeTryFinally(Stmt block, Stmt finallyBlock) {
        return new TryFinallyStmt(this.getSourceLocation(), block, finallyBlock);
    }

    public TryCatchStmt makeTryCatch(BlockStmt block, FormalDec formal, Stmt catchStmt) {
        return this.makeTryCatch(block, new CatchClause(this.getSourceLocation(), formal, catchStmt));
    }

    public TryCatchStmt makeTryCatch(BlockStmt block, CatchClause catchClause) {
        return new TryCatchStmt(this.getSourceLocation(), block, new CatchClauses(this.getSourceLocation(), catchClause));
    }

    public WhileStmt makeWhile(Expr test, Stmt body) {
        return new WhileStmt(this.getSourceLocation(), test, body);
    }

    public ReturnStmt makeReturn() {
        return new ReturnStmt(this.getSourceLocation());
    }

    public ReturnStmt makeReturn(Expr e) {
        return new ReturnStmt(this.getSourceLocation(), e);
    }

    public ThrowStmt makeThrow(Expr e) {
        return new ThrowStmt(this.getSourceLocation(), e);
    }

    public ThrowStmt makeThrow(Type t) {
        return new ThrowStmt(this.getSourceLocation(), this.makeNew(t));
    }

    public ThrowStmt makeThrow(Type t, String message) {
        return new ThrowStmt(this.getSourceLocation(), this.makeNew(t, this.makeLiteral(message)));
    }

    public CatchClause makeCatch(FormalDec formal, BlockStmt body) {
        return new CatchClause(this.getSourceLocation(), formal, body);
    }

    public LabeledStmt makeLabeled(String label, Stmt stmt) {
        return new LabeledStmt(this.getSourceLocation(), label, stmt);
    }

    public Stmt makeBreak(String label) {
        return new BreakStmt(this.getSourceLocation(), label);
    }

    public Stmt makeContinue(String label) {
        return new ContinueStmt(this.getSourceLocation(), label);
    }

    public BlockStmt makeBlock() {
        return new BlockStmt(this.getSourceLocation(), new Stmts(this.getSourceLocation()));
    }

    public BlockStmt makeBlock(ASTObject s1) {
        if (s1 instanceof Stmts) {
            return new BlockStmt(this.getSourceLocation(), (Stmts)s1);
        }
        return new BlockStmt(this.getSourceLocation(), s1);
    }

    public BlockStmt makeBlock(ASTObject s1, ASTObject s2) {
        return new BlockStmt(this.getSourceLocation(), s1, s2);
    }

    public BlockStmt makeBlock(ASTObject s1, ASTObject s2, ASTObject s3) {
        return new BlockStmt(this.getSourceLocation(), s1, s2, s3);
    }

    public BlockStmt makeBlock(ASTObject s1, ASTObject s2, ASTObject s3, ASTObject s4) {
        return new BlockStmt(this.getSourceLocation(), s1, s2, s3, s4);
    }

    public BlockStmt makeBlock(Stmts stmts) {
        return new BlockStmt(this.getSourceLocation(), stmts);
    }

    public Stmts makeStmts() {
        return new Stmts(this.getSourceLocation());
    }

    public Stmts makeStmts(Stmt s1) {
        return new Stmts(this.getSourceLocation(), s1);
    }

    public Stmts makeStmts(Stmt s1, Stmt s2) {
        return new Stmts(this.getSourceLocation(), s1, s2);
    }

    public Stmts makeStmts(Stmt s1, Stmt s2, Stmt s3) {
        return new Stmts(this.getSourceLocation(), s1, s2, s3);
    }

    public EmptyStmt makeEmptyStmt() {
        return new EmptyStmt(this.getSourceLocation());
    }

    public InterfaceDec makeInnerInterface(TypeDec outerTypeDec, Modifiers modifiers, String name, TypeDs _implements) {
        InterfaceDec ret = new InterfaceDec(this.getSourceLocation(), modifiers, name, _implements, new Decs(this.getSourceLocation()));
        outerTypeDec.getBody().add(ret);
        return ret;
    }

    public InterfaceDec makeInterface(Modifiers modifiers, String name, TypeDs _implements) {
        InterfaceDec ret = new InterfaceDec(this.getSourceLocation(), modifiers, name, _implements, new Decs(this.getSourceLocation()));
        return ret;
    }

    public ClassDec makeClass(Modifiers modifiers, String name, TypeD superClass, TypeDs _implements) {
        ClassDec ret = new ClassDec(this.getSourceLocation(), modifiers, name, superClass, _implements, new Decs(this.getSourceLocation()));
        return ret;
    }

    public AnonymousMethodExpr makeAnonMethod(Type retType, Stmts stmts) {
        return new AnonymousMethodExpr(this.getSourceLocation(), this.makeExprs(), this.makeMethod(this.makeModifiers(0), retType, "anon", this.makeFormals(), this.makeBlock(stmts)));
    }
}

