/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.compiler.base.CompilationUnitPass;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.TypeDec;

public abstract class ParallelCompilerPass
extends CompilerObject
implements CompilationUnitPass {
    private List cuList = new LinkedList();
    private int finished = 0;

    public ParallelCompilerPass(JavaCompiler compiler) {
        super(compiler);
    }

    public abstract String getDisplayName();

    public double getWorkEstimate() {
        return 1.0;
    }

    public int getNumThreads() {
        return this.getOptions().procs;
    }

    public synchronized CompilationUnit getWorkCu() {
        if (this.cuList.size() == 0) {
            return null;
        }
        return (CompilationUnit)this.cuList.remove(0);
    }

    public synchronized void setFinished() {
        ++this.finished;
    }

    public void transformWorld() {
        if (this.getDisplayName() != null) {
            this.getCompiler().beginSection(this.getDisplayName());
        }
        Iterator i = this.getWorld().getCompilationUnits().iterator();
        while (i.hasNext()) {
            CompilationUnit cu = (CompilationUnit)i.next();
            this.cuList.add(cu);
        }
        this.runThreads();
    }

    void runThreads() {
        int i = 0;
        while (i < this.getNumThreads()) {
            new PassThread().start();
            ++i;
        }
        Thread myThread = Thread.currentThread();
        while (this.finished < this.getNumThreads()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    public void transform(CompilationUnit cu) {
        Iterator j = cu.getDefinedTypes().iterator();
        while (j.hasNext()) {
            TypeDec td = (TypeDec)j.next();
            this.transform(td);
        }
    }

    public void transform(TypeDec td) {
    }

    class PassThread
    extends Thread {
        PassThread() {
        }

        public void run() {
            CompilationUnit cu = ParallelCompilerPass.this.getWorkCu();
            while (cu != null) {
                ParallelCompilerPass.this.transform(cu);
                ParallelCompilerPass.this.getCompiler().completedFile(ParallelCompilerPass.this, cu);
                cu = ParallelCompilerPass.this.getWorkCu();
            }
            ParallelCompilerPass.this.setFinished();
        }
    }
}

