/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.TypeDec;

public class ForwardReferenceChecker
extends WalkerPass {
    public ForwardReferenceChecker(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "checking forward references";
    }

    public ASTObject process(ASTObject node) {
        node.walkForwardReference(this);
        return node;
    }

    public ForwardReferenceChecker createTypeChecker(TypeDec ty) {
        return new TypeChecker(this.getCompiler(), ty);
    }

    public ForwardReferenceChecker createInitializerChecker(boolean isStatic) {
        throw new RuntimeException("found initializer while walking with " + this);
    }

    public ForwardReferenceChecker createBodyChecker() {
        throw new RuntimeException("found body while walking with " + this);
    }

    public void addFieldDec(FieldDec f) {
        throw new RuntimeException("found field while walking with " + this);
    }

    public void checkReference(FieldAccessExpr f) {
    }

    public String toString() {
        return "<ForwardReferenceChecker in Compilation Unit>";
    }

    static class BodyChecker
    extends ForwardReferenceChecker {
        BodyChecker(JavaCompiler compiler) {
            super(compiler);
        }

        public ForwardReferenceChecker createBodyChecker() {
            return this;
        }

        public String toString() {
            return "<ForwardReferenceChecker in Body>";
        }
    }

    static class InitializerChecker
    extends ForwardReferenceChecker {
        boolean isStatic;
        TypeDec context;
        Set fields;

        InitializerChecker(JavaCompiler compiler, boolean isStatic, TypeDec context, Set fields) {
            super(compiler);
            this.isStatic = isStatic;
            this.context = context;
            this.fields = fields;
        }

        public ForwardReferenceChecker createBodyChecker() {
            return this;
        }

        public void checkReference(FieldAccessExpr e) {
            FieldDec dec = e.getFieldDec();
            if (dec.isStatic() != this.isStatic) {
                return;
            }
            if (dec.getDeclaringType().getTypeDec() != this.context) {
                return;
            }
            if (this.fields.contains(dec)) {
                return;
            }
            e.showError("Illegal forward reference");
        }

        public String toString() {
            return "<ForwardReferenceChecker in " + (this.isStatic ? "static" : "dynamic") + " Init with fields " + this.fields + ">";
        }
    }

    static class TypeChecker
    extends ForwardReferenceChecker {
        TypeDec context;
        Set statics = new HashSet();
        Set dynamics = new HashSet();

        TypeChecker(JavaCompiler compiler, TypeDec ty) {
            super(compiler);
            this.context = ty;
        }

        public ForwardReferenceChecker createInitializerChecker(boolean isStatic) {
            return new InitializerChecker(this.getCompiler(), isStatic, this.context, isStatic ? this.statics : this.dynamics);
        }

        public ForwardReferenceChecker createBodyChecker() {
            return new BodyChecker(this.getCompiler());
        }

        public void addFieldDec(FieldDec f) {
            (f.isStatic() ? this.statics : this.dynamics).add(f);
        }

        public String toString() {
            return "<ForwardReferenceChecker in TypeDec with dynamics " + this.dynamics + " and statics " + this.statics + ">";
        }
    }
}

