/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;

public class ExprMaker
extends MovingWalker {
    boolean mayReturn;
    boolean mustReturn;
    Map inParams = new HashMap();
    Map outParams = new HashMap();
    boolean needsThis = false;

    public ExprMaker(JavaCompiler compiler) {
        super(compiler);
    }

    public Map getInParams() {
        return this.inParams;
    }

    public Map getOutParams() {
        return this.outParams;
    }

    public boolean getNeedsThis() {
        return this.needsThis;
    }

    public Expr moveThisExpr(ThisExpr thisExpr, Type thisType) {
        this.needsThis = true;
        return super.moveThisExpr(thisExpr, thisType);
    }

    VarDec lookupVarDec(VarDec oldDec) {
        VarDec ret = (VarDec)this.remapNodes.get(oldDec);
        if (ret != null) {
            return ret;
        }
        FormalDec formal = this.getAST().makeFormal(oldDec.getType(), oldDec.getId());
        if (oldDec.isFinal()) {
            formal.getModifiers().setFinal(true);
        }
        this.inParams.put(oldDec, formal);
        this.remapNodes.put(oldDec, formal);
        return formal;
    }

    public Expr moveVarExpr(VarExpr var) {
        var.setVarDec(this.lookupVarDec(var.getVarDec()));
        return var;
    }

    public Expr makeExpr(ASTObject object, boolean allowVoid) {
        AST ast = this.getAST();
        CodeDec inCode = object.getEnclosingCodeDec();
        BlockStmt block = ast.makeBlock(this.process(object));
        Formals formals = ast.makeFormals();
        Exprs args = ast.makeExprs();
        Iterator i = this.inParams.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            VarDec varDec = (VarDec)entry.getKey();
            varDec.getModifiers().setFinal(true);
            args.add(ast.makeVar(varDec));
            FormalDec formalDec = (FormalDec)entry.getValue();
            formals.add(formalDec);
        }
        Modifiers mods = ast.makeModifiers(2);
        mods.setStatic(inCode.isStatic());
        Type returnType = inCode.getResultType();
        String id = this.getAST().makeGeneratedName(inCode.getId() + "$ajcPostAround" + inCode.getBytecodeTypeDec().getBody().size());
        MethodDec newMethod = ast.makeMethod(mods, returnType, id, formals, block);
        inCode.getBytecodeTypeDec().getBody().add(newMethod);
        Expr thisExpr = ast.makePrimary((Dec)newMethod, inCode.getBytecodeTypeDec());
        CallExpr ret = ast.makeCall(newMethod, thisExpr, args);
        if (!allowVoid && newMethod.getResultType().isVoid()) {
            MethodDec voidWrapper = (MethodDec)CopyWalker.copy(newMethod);
            voidWrapper.setId(newMethod.getId() + "$ajcVoidWrapper");
            voidWrapper.setResultTypeD(this.getTypeManager().getObjectType().makeTypeD());
            newMethod.getBytecodeTypeDec().getBody().add(voidWrapper);
            CallExpr internalCall = ast.makeCall(newMethod, ast.makePrimary((Dec)newMethod, inCode.getBytecodeTypeDec()), voidWrapper.getFormals().makeExprs());
            Stmts stmts = ast.makeStmts(ast.makeStmt(internalCall), ast.makeReturn(ast.makeNull()));
            voidWrapper.getBody().setStmts(stmts);
            thisExpr = ast.makePrimary((Dec)voidWrapper, newMethod.getBytecodeTypeDec());
            ret = ast.makeCall(voidWrapper, thisExpr, args);
        }
        return ret;
    }
}

