/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.CompilationUnitPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.TopTypesFinder;
import org.aspectj.compiler.base.WorldPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;

public class CodeGenerator
extends AbstractCompilerPass
implements WorldPass,
CompilationUnitPass {
    final int FILE_SIZE_GUESS = 32768;

    public CodeGenerator(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "generating Java sources";
    }

    public void clearState() {
    }

    public void addFileToCompile(File f) {
        this.getCompiler().addFileToCompile(f);
    }

    public void transform(CompilationUnit cu) {
        File outputDir = this.getOptions().workingDir;
        try {
            this.unparseCompilationUnit(outputDir, cu);
        }
        catch (IOException ioe) {
            this.getCompiler().internalError(ioe, cu);
            return;
        }
    }

    public void unparseCompilationUnit(File outputdir, CompilationUnit cu) throws IOException {
        Decs decs = cu.getDecs();
        int N = decs.size();
        int i = 0;
        while (i < N) {
            Dec dec = decs.get(i);
            this.unparseTypeDec(outputdir, (TypeDec)dec);
            ++i;
        }
    }

    private void unparseTypeDec(File outputdir, TypeDec typeDec) throws IOException {
        this.getCompiler().showMessage(this, typeDec.toShortString());
        File sourceFile = typeDec.getCompilationUnit().getSourceFile();
        File inputdir = sourceFile.getParent() == null ? new File(".") : new File(sourceFile.getParent());
        String filename = typeDec.getId() + ".java";
        String packagename = typeDec.getPackageName();
        Set topLevelTypes = this.getTopLevelTypes(typeDec);
        File packagedir = typeDec.getPackageDir(outputdir);
        packagedir.mkdirs();
        File clsDir = packagename == null ? this.getOptions().outputDir : new File(this.getOptions().outputDir, packagename);
        File clsFile = new File(clsDir, typeDec.getId() + ".class");
        File outFile = new File(packagedir, filename);
        CodeWriter unparser = new CodeWriter(this.getCompiler(), 32768, null);
        unparser.writeHeader();
        if (typeDec.getCompilationUnit().getPackageName() != null) {
            unparser.write("package ");
            unparser.write(typeDec.getCompilationUnit().getPackageName());
            unparser.writeln(";");
        }
        Iterator iter = topLevelTypes.iterator();
        while (iter.hasNext()) {
            Type topType = (Type)iter.next();
            if (topType.isInnerType() || !topType.isClass() && !topType.isInterface() || topType == this.getTypeManager().TYPE_NOT_FOUND || topType.getString().startsWith("<")) continue;
            unparser.writeln("import " + topType.getString() + ";");
        }
        unparser.write(typeDec.getCompilationUnit().getImports());
        try {
            unparser.write(typeDec);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            unparser.writeTo(System.out);
            throw e;
        }
        if (outputdir == null) {
            unparser.writeTo(System.out);
        } else {
            if (!outFile.exists() || outFile.getCanonicalPath().equals(sourceFile.getCanonicalPath())) {
                // empty if block
            }
            FileOutputStream fileStream = new FileOutputStream(outFile);
            try {
                unparser.writeTo(fileStream);
                Object var16_16 = null;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                fileStream.close();
                throw throwable;
            }
            fileStream.close();
            this.addFileToCompile(outFile);
        }
    }

    private Set getTopLevelTypes(ASTObject typeDec) {
        HashSet topTypesSet = new HashSet();
        if (typeDec.getCompilationUnit().getPackageName() == null) {
            return topTypesSet;
        }
        TopTypesFinder ttFinder = new TopTypesFinder(this.getCompiler(), topTypesSet);
        ttFinder.process(typeDec);
        return topTypesSet;
    }
}

