/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CatchClauses;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.ThrowStmt;
import org.aspectj.compiler.base.ast.TryCatchStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.Walker;

public class CanThrowWalker
extends Walker {
    Stack canThrow = new Stack();
    private Set badThrows = null;

    public static void checkThrows(CodeDec codeDec) {
        if (codeDec.isSoftThrowable()) {
            return;
        }
        CanThrowWalker walker = new CanThrowWalker(codeDec);
        walker.canThrow.push(CanThrowWalker.makeThrowableSet(codeDec.getThrows()));
        if (codeDec instanceof InitializerDec && !codeDec.isStatic()) {
            TypeDec inTypeDec = codeDec.getBytecodeTypeDec();
            if (inTypeDec.isAnonymous()) {
                HashSet set = new HashSet();
                walker.collectBadThrows(set);
                walker.process(codeDec);
                inTypeDec.getSoleConstructorDec().addThrows(set);
            } else {
                Set set = null;
                Iterator i = inTypeDec.getNameType().getConstructors().iterator();
                while (i.hasNext()) {
                    Constructor c = (Constructor)i.next();
                    set = set == null ? CanThrowWalker.makeThrowableSet(c.getThrows()) : Type.intersect(set, CanThrowWalker.makeThrowableSet(c.getThrows()));
                }
                codeDec.addThrows(set);
                walker.canThrow.push(CanThrowWalker.makeThrowableSet(codeDec.getThrows()));
                walker.process(codeDec);
            }
        } else {
            walker.process(codeDec);
        }
    }

    private CanThrowWalker(CodeDec codeDec) {
        super(codeDec.getCompiler());
    }

    void collectBadThrows(Set set) {
        this.badThrows = set;
    }

    static Set makeThrowableSet(TypeDs _throws) {
        if (_throws == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Type> ret = new HashSet<Type>();
        int N = _throws.size();
        int i = 0;
        while (i < N) {
            Type exceptionType = _throws.get(i).getType();
            ret.add(exceptionType);
            ++i;
        }
        return ret;
    }

    Collection makeThrowableSet(CatchClauses catchClauses) {
        if (catchClauses == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Type> ret = new HashSet<Type>();
        int N = catchClauses.size();
        int i = 0;
        while (i < N) {
            Type exceptionType = catchClauses.get(i).getFormal().getType();
            ret.add(exceptionType);
            ++i;
        }
        return ret;
    }

    boolean checkLegalThrow(ASTObject where, Type throwType) {
        if (throwType.isUncheckedThrowable()) {
            return true;
        }
        Iterator i = ((AbstractList)this.canThrow).iterator();
        while (i.hasNext()) {
            if (!Type.hasMatchingType((Collection)i.next(), throwType)) continue;
            return true;
        }
        if (this.badThrows != null) {
            this.badThrows.add(throwType);
            return true;
        }
        where.showError("unreported exception " + throwType.getString() + "; must be caught or declared to be thrown");
        return false;
    }

    void checkLegalThrows(ASTObject where, TypeDs throwTypeDs) {
        if (throwTypeDs == null) {
            return;
        }
        int i = 0;
        while (i < throwTypeDs.size()) {
            if (!this.checkLegalThrow(where, throwTypeDs.get(i).getType())) {
                return;
            }
            ++i;
        }
    }

    public ASTObject process(ASTObject node) {
        if (node instanceof TryCatchStmt) {
            TryCatchStmt tryStmt = (TryCatchStmt)node;
            this.canThrow.push(this.makeThrowableSet(tryStmt.getCatches()));
            super.process(tryStmt.getBody());
            this.canThrow.pop();
            super.process(tryStmt.getCatches());
            return node;
        }
        if (node instanceof ThrowStmt) {
            ThrowStmt throwStmt = (ThrowStmt)node;
            this.checkLegalThrow(throwStmt, throwStmt.getExpr().getType());
        } else if (node instanceof CallExpr) {
            CallExpr callExpr = (CallExpr)node;
            if (callExpr.isSoftThrowable()) {
                return super.process(node);
            }
            if (callExpr.getId().equals("aspectOf")) {
                return super.process(node);
            }
            Method method = callExpr.getMethod();
            if (method == null) {
                return super.process(node);
            }
            this.checkLegalThrows(callExpr, method.getThrows());
        } else if (node instanceof NewInstanceExpr) {
            NewInstanceExpr newExpr = (NewInstanceExpr)node;
            if (newExpr.isSoftThrowable()) {
                return super.process(node);
            }
            Constructor init = newExpr.getConstructor();
            this.checkLegalThrows(newExpr, init.getThrows());
        } else if (node instanceof ConstructorCallExpr) {
            ConstructorCallExpr newExpr = (ConstructorCallExpr)node;
            Constructor init = newExpr.getConstructor();
            this.checkLegalThrows(newExpr, init.getThrows());
        }
        if (node instanceof TypeDec) {
            return node;
        }
        return super.process(node);
    }
}

