/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ControlContext;
import org.aspectj.compiler.base.ast.Stmt;

public class ByteCodeCleanupPass
extends WalkerPass {
    private boolean liveFlag = true;
    private ControlContext context = new ControlContext();
    private Set breaks = new HashSet();
    private Set continues = new HashSet();

    public ByteCodeCleanupPass(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "clean up ast";
    }

    public ASTObject process(ASTObject object) {
        object.walkCleanup(this);
        ASTObject ret = object.postCleanup(this);
        if (ret instanceof Stmt) {
            ((Stmt)ret).setCompletesNormally(this.isLive());
        }
        return ret;
    }

    public void setLive(boolean b) {
        this.liveFlag = b;
    }

    public boolean isLive() {
        return this.liveFlag;
    }

    public void enterContext(Stmt s) {
        this.context.enter(s);
    }

    public void leaveContext() {
        this.context.exit();
    }

    public void doBreak(String label) {
        this.breaks.add(this.context.getBreakTarget(label));
    }

    public void doContinue(String label) {
        this.continues.add(this.context.getContinueTarget(label));
    }

    public boolean isBroken(Stmt s) {
        return this.breaks.contains(s);
    }

    public boolean isContinued(Stmt s) {
        return this.continues.contains(s);
    }
}

