/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.SourceLocation;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BasicAssignExpr;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SOLink;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedSuperDec;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.compiler.crosscuts.ast.ShowErrorDec;
import org.aspectj.compiler.crosscuts.ast.SoftThrowableDec;

public class StructureNodeFactory {
    private static Hashtable programElementNodes = new Hashtable();
    private static final ProgramElementNode UNRESOLVED_LINK_NODE = new ProgramElementNode("<error: unresolved link>", ProgramElementNode.Kind.ERROR, null, null, "", "", "", null, null, null, false, null);

    public static void clear() {
        programElementNodes.clear();
    }

    public static ProgramElementNode makeNode(ASTObject astObject, List relations, List children) {
        return StructureNodeFactory.makeNode(astObject, relations, children, false);
    }

    public static LinkNode makeLink(ASTObject astObject, boolean terminal) {
        ProgramElementNode peNode = null;
        peNode = terminal ? StructureNodeFactory.makeNode(astObject, null, null, false) : StructureNodeFactory.makeNode(astObject, null, null, true);
        if (peNode == null) {
            return new LinkNode(UNRESOLVED_LINK_NODE);
        }
        return new LinkNode(peNode);
    }

    private static ProgramElementNode makeNode(ASTObject astObject, List relations, List children, boolean resolve) {
        if (resolve) {
            if (astObject instanceof InitializerDec) {
                InitializerDec initDec = (InitializerDec)astObject;
                return (ProgramElementNode)programElementNodes.get(initDec.getDeclaringType().getTypeDec());
            }
            if (astObject instanceof Decs) {
                Decs decs = (Decs)astObject;
                return (ProgramElementNode)programElementNodes.get(decs.getDeclaringType().getTypeDec());
            }
            ProgramElementNode peNode = (ProgramElementNode)programElementNodes.get(astObject);
            if (peNode == null) {
                return StructureNodeFactory.makeNode(astObject, null, null, false);
            }
            return peNode;
        }
        String declaringType = "";
        if (astObject.getDeclaringType() != null) {
            declaringType = astObject.getDeclaringType().toShortString();
        }
        SourceLocation sourceLocation = new SourceLocation(astObject.getSourceLocation().getSourceFileName(), astObject.getSourceLocation().getBeginLine(), astObject.getSourceLocation().getEndLine(), astObject.getSourceLocation().getBeginColumn());
        ProgramElementNode newNode = new ProgramElementNode(StructureNodeFactory.genSignature(astObject).trim(), StructureNodeFactory.genKind(astObject), StructureNodeFactory.genModifiers(astObject), StructureNodeFactory.genAccessibility(astObject), declaringType, StructureNodeFactory.genPackageName(astObject), StructureNodeFactory.genFormalComment(astObject), sourceLocation, relations, children, StructureNodeFactory.isMemberKind(astObject), astObject);
        programElementNodes.put(astObject, newNode);
        newNode.setRunnable(StructureNodeFactory.genIsRunnable(newNode));
        StructureNodeFactory.setSpecifiers(astObject, newNode);
        return newNode;
    }

    private static void setSpecifiers(ASTObject astObject, ProgramElementNode node) {
        if (astObject instanceof MethodDec) {
            Method method = ((MethodDec)astObject).getMethod();
            Iterator it = method.getDeclaringType().getDirectSuperTypes().iterator();
            while (it.hasNext()) {
                NameType type = (NameType)it.next();
                SemanticObject so = type.findMatchingSemanticObject(method);
                if (so == null || !(so instanceof Method)) continue;
                Method superMethod = (Method)so;
                if (so.isAbstract()) {
                    node.setImplementor(true);
                    continue;
                }
                node.setOverrider(true);
            }
        }
    }

    private static boolean genIsRunnable(ProgramElementNode node) {
        return node.getModifiers().contains(ProgramElementNode.Modifiers.STATIC) && node.getAccessibility().equals(ProgramElementNode.Accessibility.PUBLIC) && node.getSignature().equals("main(String[])");
    }

    private static boolean genIsStmntKind(ASTObject astObject) {
        return astObject instanceof CatchClause || astObject instanceof SOLink || astObject instanceof BasicAssignExpr;
    }

    private static List genModifiers(ASTObject astObject) {
        ArrayList<ProgramElementNode.Modifiers> modifiers = new ArrayList<ProgramElementNode.Modifiers>();
        if (astObject instanceof Dec) {
            Dec dec = (Dec)astObject;
            if (dec.getModifiers().isStrict()) {
                modifiers.add(ProgramElementNode.Modifiers.STRICTFP);
            }
            if (dec.getModifiers().isAbstract()) {
                modifiers.add(ProgramElementNode.Modifiers.ABSTRACT);
            }
            if (dec.getModifiers().isSynchronized()) {
                modifiers.add(ProgramElementNode.Modifiers.SYNCHRONIZED);
            }
            if (dec.getModifiers().isNative()) {
                modifiers.add(ProgramElementNode.Modifiers.NATIVE);
            }
            if (dec.getModifiers().isFinal()) {
                modifiers.add(ProgramElementNode.Modifiers.FINAL);
            }
            if (dec.getModifiers().isTransient()) {
                modifiers.add(ProgramElementNode.Modifiers.TRANSIENT);
            }
            if (dec.getModifiers().isStatic()) {
                modifiers.add(ProgramElementNode.Modifiers.STATIC);
            }
            if (dec.getModifiers().isVolatile()) {
                modifiers.add(ProgramElementNode.Modifiers.VOLATILE);
            }
        }
        return modifiers;
    }

    private static ProgramElementNode.Accessibility genAccessibility(ASTObject astObject) {
        if (astObject instanceof Dec) {
            Dec dec = (Dec)astObject;
            if (dec.getModifiers().isPublic()) {
                return ProgramElementNode.Accessibility.PUBLIC;
            }
            if (dec.getModifiers().isProtected()) {
                return ProgramElementNode.Accessibility.PROTECTED;
            }
            if (dec.getModifiers().isPrivileged()) {
                return ProgramElementNode.Accessibility.PRIVILEGED;
            }
            if (dec.getModifiers().isPackagePrivate()) {
                return ProgramElementNode.Accessibility.PACKAGE;
            }
            if (dec.getModifiers().isPrivate()) {
                return ProgramElementNode.Accessibility.PRIVATE;
            }
        }
        return ProgramElementNode.Accessibility.PUBLIC;
    }

    private static ProgramElementNode.Kind genKind(ASTObject astObject) {
        if (astObject instanceof CompilationUnit) {
            return ProgramElementNode.Kind.FILE_JAVA;
        }
        if (StructureNodeFactory.genIsStmntKind(astObject)) {
            return ProgramElementNode.Kind.CODE;
        }
        if (astObject instanceof Dec) {
            String kindString = ((Dec)astObject).getKind();
            return ProgramElementNode.Kind.getKindForString(kindString);
        }
        return ProgramElementNode.Kind.ERROR;
    }

    private static boolean isMemberKind(ASTObject astObject) {
        if (astObject instanceof Dec) {
            Dec dec = (Dec)astObject;
            return dec.getDeclaringType() != null && !dec.getDeclaringType().equals(dec.getName());
        }
        return false;
    }

    private static String genPackageName(ASTObject astObject) {
        if (astObject instanceof TypeDec) {
            return ((TypeDec)astObject).getPackageName();
        }
        if (astObject instanceof CompilationUnit) {
            return ((CompilationUnit)astObject).getPackageName();
        }
        if (astObject.getDeclaringType() != null) {
            return astObject.getDeclaringType().getPackageName();
        }
        return "";
    }

    private static String genDeclaringType(ASTObject astObject) {
        if (astObject != null && astObject.getDeclaringType() != null) {
            return astObject.getDeclaringType().toShortString();
        }
        return null;
    }

    private static String genFormalComment(ASTObject astObject) {
        try {
            return (String)astObject.getComment().getClass().getMethod("commentText", new Class[0]).invoke((Object)astObject.getComment(), new Object[0]);
        }
        catch (Throwable t) {
            if (astObject != null) {
                return astObject.getFormalComment();
            }
            return "";
        }
    }

    private static String genSignature(ASTObject astObject) {
        String name = "";
        if (astObject instanceof CompilationUnit) {
            return astObject.getSourceFile().getName();
        }
        if (astObject instanceof MethodDec) {
            Method method = ((MethodDec)astObject).getMethod();
            return method.getName() + method.getFormals().toShortString();
        }
        if (astObject instanceof TypeDec) {
            return ((TypeDec)astObject).getSourceExtendedId();
        }
        if (astObject instanceof FieldDec) {
            return ((FieldDec)astObject).getName();
        }
        if (astObject instanceof ConstructorDec) {
            ConstructorDec constructorDec = (ConstructorDec)astObject;
            return constructorDec.getDeclaringType().getSourceExtendedId() + constructorDec.getFormals().toShortString();
        }
        if (astObject instanceof IntroducedDec) {
            IntroducedDec introDec = (IntroducedDec)astObject;
            return introDec.getTargets().toShortString() + '.' + StructureNodeFactory.genSignature(introDec.getDec());
        }
        if (astObject instanceof PointcutDec) {
            PointcutDec pointcutDec = (PointcutDec)astObject;
            return pointcutDec.getName() + pointcutDec.getFormals().toShortString();
        }
        if (astObject instanceof ShowErrorDec) {
            ShowErrorDec errorDec = (ShowErrorDec)astObject;
            return errorDec.toShortString();
        }
        if (astObject instanceof SoftThrowableDec) {
            SoftThrowableDec softThrowableDec = (SoftThrowableDec)astObject;
            return softThrowableDec.toShortString();
        }
        if (astObject instanceof IntroducedSuperDec) {
            IntroducedSuperDec introducedSuperDec = (IntroducedSuperDec)astObject;
            return introducedSuperDec.toShortString();
        }
        if (astObject instanceof AdviceDec) {
            AdviceDec adviceDec = (AdviceDec)astObject;
            return adviceDec.toShortString();
        }
        if (astObject instanceof SOLink) {
            SOLink soLink = (SOLink)((Object)astObject);
            return StructureNodeFactory.genSignature(soLink.getTarget().getCorrespondingDec());
        }
        if (astObject instanceof CatchClause) {
            CatchClause catchClause = (CatchClause)astObject;
            return catchClause.getFormal().getType().getSourceExtendedId();
        }
        if (astObject instanceof BasicAssignExpr) {
            return astObject.unparse();
        }
        return "? " + astObject.toShortString();
    }
}

