/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.associations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.Association;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.Relation;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.asm.internal.StructureNodeFactory;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BasicAssignExpr;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedDec;

public class Advice
implements Association {
    public static final String NAME = "Advice";
    public static final Relation METHOD_RELATION = new Relation("affects methods", "method affected by", "Advice", true, false);
    public static final Relation METHOD_CALL_SITE_RELATION = new Relation("affects method call sites", "method call site affected by", "Advice", true, false);
    public static final Relation CONSTRUCTOR_RELATION = new Relation("affects constructors", "constructor affected by", "Advice", true, false);
    public static final Relation CONSTRUCTOR_CALL_SITE_RELATION = new Relation("affects constructions", "construction affected by", "Advice", true, false);
    public static final Relation HANDLER_RELATION = new Relation("affects handlers", "handler affected by", "Advice", true, false);
    public static final Relation INITIALIZER_RELATION = new Relation("affects initializers", "initializer affected by", "Advice", true, false);
    public static final Relation FIELD_ACCESS_RELATION = new Relation("affects field access", "field access affected by", "Advice", true, false);
    public static final Relation INTRODUCTION_RELATION = new Relation("affects introduction", "introduction affected by", "Advice", true, false);
    private List relations = new ArrayList();

    public Advice() {
        this.relations.add(METHOD_RELATION);
        this.relations.add(METHOD_CALL_SITE_RELATION);
        this.relations.add(CONSTRUCTOR_RELATION);
        this.relations.add(CONSTRUCTOR_CALL_SITE_RELATION);
        this.relations.add(HANDLER_RELATION);
        this.relations.add(INITIALIZER_RELATION);
        this.relations.add(FIELD_ACCESS_RELATION);
        this.relations.add(INTRODUCTION_RELATION);
    }

    public List getRelations() {
        return this.relations;
    }

    public List getRelationNodes(ASTObject astObject) {
        ArrayList<RelationNode> relations = new ArrayList<RelationNode>();
        ArrayList<LinkNode> methods = new ArrayList<LinkNode>();
        ArrayList<LinkNode> methodCallSites = new ArrayList<LinkNode>();
        ArrayList<LinkNode> constructors = new ArrayList<LinkNode>();
        ArrayList<LinkNode> constructorCallSites = new ArrayList<LinkNode>();
        ArrayList<LinkNode> handlers = new ArrayList<LinkNode>();
        ArrayList<LinkNode> initializers = new ArrayList<LinkNode>();
        ArrayList<LinkNode> fieldAccesses = new ArrayList<LinkNode>();
        ArrayList<LinkNode> introductions = new ArrayList<LinkNode>();
        Set forwardCorrs = StructureModelManager.correspondences.getAffects(astObject);
        Set backCorrs = StructureModelManager.correspondences.getAffectedBy(astObject);
        if (astObject instanceof AdviceDec) {
            Iterator it = forwardCorrs.iterator();
            while (it.hasNext()) {
                ASTObject node = (ASTObject)it.next();
                LinkNode link = StructureNodeFactory.makeLink(node, false);
                if (node instanceof MethodDec) {
                    if (((MethodDec)node).isSynthetic()) {
                        ASTObject resolvedNode = this.resolveSyntheticMethodToIntroduction((MethodDec)node);
                        introductions.add(StructureNodeFactory.makeLink(resolvedNode, false));
                        continue;
                    }
                    methods.add(link);
                    continue;
                }
                if (node instanceof CallExpr) {
                    methodCallSites.add(link);
                    continue;
                }
                if (node instanceof ConstructorDec) {
                    constructors.add(link);
                    continue;
                }
                if (node instanceof NewInstanceExpr) {
                    constructorCallSites.add(link);
                    continue;
                }
                if (node instanceof CatchClause) {
                    handlers.add(link);
                    continue;
                }
                if (node instanceof InitializerDec) {
                    initializers.add(link);
                    continue;
                }
                if (node instanceof FieldDec) {
                    fieldAccesses.add(link);
                    continue;
                }
                if (!(node instanceof BasicAssignExpr) && !(node instanceof FieldAccessExpr)) continue;
                fieldAccesses.add(link);
            }
            if (!methods.isEmpty()) {
                relations.add(new RelationNode(METHOD_RELATION, METHOD_RELATION.getForwardNavigationName(), methods));
            }
            if (!methodCallSites.isEmpty()) {
                relations.add(new RelationNode(METHOD_RELATION, METHOD_CALL_SITE_RELATION.getForwardNavigationName(), methodCallSites));
            }
            if (!constructors.isEmpty()) {
                relations.add(new RelationNode(CONSTRUCTOR_RELATION, CONSTRUCTOR_RELATION.getForwardNavigationName(), constructors));
            }
            if (!constructorCallSites.isEmpty()) {
                relations.add(new RelationNode(CONSTRUCTOR_CALL_SITE_RELATION, CONSTRUCTOR_CALL_SITE_RELATION.getForwardNavigationName(), constructorCallSites));
            }
            if (!handlers.isEmpty()) {
                relations.add(new RelationNode(HANDLER_RELATION, HANDLER_RELATION.getForwardNavigationName(), handlers));
            }
            if (!initializers.isEmpty()) {
                relations.add(new RelationNode(INITIALIZER_RELATION, INITIALIZER_RELATION.getForwardNavigationName(), initializers));
            }
            if (!fieldAccesses.isEmpty()) {
                relations.add(new RelationNode(FIELD_ACCESS_RELATION, FIELD_ACCESS_RELATION.getForwardNavigationName(), fieldAccesses));
            }
            if (!introductions.isEmpty()) {
                relations.add(new RelationNode(INTRODUCTION_RELATION, INTRODUCTION_RELATION.getForwardNavigationName(), introductions));
            }
        } else {
            Set adviceDecs;
            if (astObject instanceof IntroducedDec && (adviceDecs = this.resolveAdviceAffectingIntroduction((IntroducedDec)astObject)) != null) {
                Iterator adIt = adviceDecs.iterator();
                while (adIt.hasNext()) {
                    introductions.add(StructureNodeFactory.makeLink((ASTObject)adIt.next(), false));
                }
            }
            Iterator it = backCorrs.iterator();
            while (it.hasNext()) {
                ASTObject node = (ASTObject)it.next();
                if (!(node instanceof AdviceDec)) continue;
                if (astObject instanceof MethodDec) {
                    methods.add(StructureNodeFactory.makeLink(node, false));
                    continue;
                }
                if (astObject instanceof CallExpr) {
                    methodCallSites.add(StructureNodeFactory.makeLink(node, false));
                    continue;
                }
                if (astObject instanceof ConstructorDec) {
                    constructors.add(StructureNodeFactory.makeLink(node, false));
                    continue;
                }
                if (astObject instanceof NewInstanceExpr) {
                    constructorCallSites.add(StructureNodeFactory.makeLink(node, false));
                    continue;
                }
                if (astObject instanceof CatchClause) {
                    handlers.add(StructureNodeFactory.makeLink(node, false));
                    continue;
                }
                if (astObject instanceof InitializerDec) {
                    initializers.add(StructureNodeFactory.makeLink(node, false));
                    continue;
                }
                if (astObject instanceof FieldDec) {
                    fieldAccesses.add(StructureNodeFactory.makeLink(node, false));
                    continue;
                }
                if (!(astObject instanceof BasicAssignExpr) && !(astObject instanceof FieldAccessExpr)) continue;
                fieldAccesses.add(StructureNodeFactory.makeLink(node, false));
            }
            if (!methods.isEmpty()) {
                relations.add(new RelationNode(METHOD_RELATION, METHOD_RELATION.getBackNavigationName(), methods));
            }
            if (!methodCallSites.isEmpty()) {
                relations.add(new RelationNode(METHOD_CALL_SITE_RELATION, METHOD_CALL_SITE_RELATION.getBackNavigationName(), methodCallSites));
            }
            if (!constructors.isEmpty()) {
                relations.add(new RelationNode(CONSTRUCTOR_RELATION, CONSTRUCTOR_RELATION.getBackNavigationName(), constructors));
            }
            if (!constructorCallSites.isEmpty()) {
                relations.add(new RelationNode(CONSTRUCTOR_CALL_SITE_RELATION, CONSTRUCTOR_CALL_SITE_RELATION.getBackNavigationName(), constructorCallSites));
            }
            if (!handlers.isEmpty()) {
                relations.add(new RelationNode(HANDLER_RELATION, HANDLER_RELATION.getBackNavigationName(), handlers));
            }
            if (!initializers.isEmpty()) {
                relations.add(new RelationNode(INITIALIZER_RELATION, INITIALIZER_RELATION.getBackNavigationName(), initializers));
            }
            if (!fieldAccesses.isEmpty()) {
                relations.add(new RelationNode(FIELD_ACCESS_RELATION, FIELD_ACCESS_RELATION.getBackNavigationName(), fieldAccesses));
            }
            if (!introductions.isEmpty()) {
                relations.add(new RelationNode(INTRODUCTION_RELATION, INTRODUCTION_RELATION.getBackNavigationName(), introductions));
            }
        }
        return relations;
    }

    public String getName() {
        return NAME;
    }

    private ASTObject resolveSyntheticMethodToIntroduction(MethodDec node) {
        Set backCorrs = StructureModelManager.correspondences.getAffectedBy(node.getDeclaringType().getTypeDec());
        Method method = node.getMethod();
        String name = method.getDeclaringType().getName() + '.' + method.getName();
        Iterator it = backCorrs.iterator();
        while (it.hasNext()) {
            IntroducedDec introducedDec;
            Object next = it.next();
            if (!(next instanceof IntroducedDec) || !name.equals((introducedDec = (IntroducedDec)next).toShortString())) continue;
            return introducedDec;
        }
        return node;
    }

    private Set resolveAdviceAffectingIntroduction(IntroducedDec node) {
        Set forwardCorrs = StructureModelManager.correspondences.getAffects(node);
        String name = node.getId();
        Iterator it = forwardCorrs.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof TypeDec)) continue;
            TypeDec typeDec = (TypeDec)next;
            List decs = typeDec.getBody().getList();
            Iterator it2 = decs.iterator();
            while (it2.hasNext()) {
                Dec bodyDec = (Dec)it2.next();
                if (bodyDec == null || bodyDec instanceof InitializerDec || !(bodyDec instanceof MethodDec) || !bodyDec.isSynthetic() || !name.equals(bodyDec.getName())) continue;
                MethodDec methodDec = (MethodDec)bodyDec;
                return StructureModelManager.correspondences.getAffectedBy(methodDec);
            }
        }
        return null;
    }
}

