/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.swing.BuildOptionsPanel;
import org.aspectj.ajde.ui.swing.IconRegistry;
import org.aspectj.ajde.ui.swing.OptionsPanel;

public class OptionsFrame
extends JFrame {
    private static final String ABOUT_TEXT = "<html>\n<body>\n<p><b>AspectJ Development Environment (AJDE) 1.0.6</b></p>\n<p>Submit bugs at <a href=\"http://aspectj.org/bugs\">http://aspectj.org/bugs</a><br>\nFor support questions email <a href=\"mailto:support@aspectj.org\">\nsupport@aspectj.org</a> </p>\n<p>The AspectJ compiler and core tools are distributed under the Mozilla Public \nLicense version 1.1.&nbsp; This license has been approved by the Open Source \nInitiative as conforming to the Open Source Definition.&nbsp; For more \ninformation and the license please visit <a href=\"http://aspectj.org/license\">\nhttp://aspectj.org/license</a></p>\n</body>\n</html>\n";
    private JTabbedPane main_tabbedPane = new JTabbedPane();
    private JPanel button_panel = new JPanel();
    private JButton apply_button = new JButton();
    private JButton cancel_button = new JButton();
    private JButton ok_button = new JButton();
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private TitledBorder titledBorder3;
    private Border border1;
    private TitledBorder titledBorder4;
    private TitledBorder titledBorder5;
    private Border border2;
    private TitledBorder titledBorder6;
    private Box temp_box = Box.createVerticalBox();
    private Border border3;
    private TitledBorder titledBorder7;
    private Border border4;
    private TitledBorder titledBorder8;
    private Border border5;
    private TitledBorder titledBorder9;
    private Border border6;
    private TitledBorder titledBorder10;
    private ButtonGroup views_buttonGroup = new ButtonGroup();
    private Border border7;
    private TitledBorder titledBorder11;
    private Border border8;
    private TitledBorder titledBorder12;
    private JPanel about_panel = new JPanel();
    private BorderLayout borderLayout9 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JEditorPane about_editorPane = new JEditorPane();
    private BorderLayout borderLayout10 = new BorderLayout();

    public OptionsFrame(IconRegistry icons) {
        try {
            this.jbInit();
            this.setTitle("AJDE Settings");
            ((Frame)this).setIconImage(((ImageIcon)icons.getBrowserOptionsIcon()).getImage());
            ((Component)this).setSize(500, 500);
            ((Component)this).setLocation(200, 100);
            this.about_editorPane.setContentType("text/html");
            this.about_editorPane.setText(ABOUT_TEXT);
            this.addOptionsPanel(new BuildOptionsPanel());
            this.loadOptions();
        }
        catch (Exception e) {
            Ajde.getDefault().getErrorHandler().handleError("Could not open OptionsFrame", e);
        }
    }

    public void addOptionsPanel(OptionsPanel panel) {
        this.main_tabbedPane.add((Component)panel, this.main_tabbedPane.getComponentCount() - 1);
        this.loadOptions();
    }

    public void removeOptionsPanel(OptionsPanel panel) {
        this.main_tabbedPane.remove(panel);
    }

    public void showPanel(OptionsPanel panel) {
        ((Component)this).setVisible(true);
        this.main_tabbedPane.setSelectedComponent(panel);
    }

    private void loadOptions() {
        try {
            Component[] components = this.main_tabbedPane.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof OptionsPanel) {
                    ((OptionsPanel)components[i]).loadOptions();
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not load options.", ioe);
        }
    }

    private void saveOptions() {
        try {
            Component[] components = this.main_tabbedPane.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof OptionsPanel) {
                    ((OptionsPanel)components[i]).saveOptions();
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not load options.", ioe);
        }
    }

    private void close() {
        ((Component)this).setVisible(false);
    }

    private void apply_button_actionPerformed(ActionEvent e) {
        this.saveOptions();
    }

    private void ok_button_actionPerformed(ActionEvent e) {
        this.saveOptions();
        this.close();
    }

    private void cancel_button_actionPerformed(ActionEvent e) {
        this.close();
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Sorting");
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Associations (navigeable relations between sturcture nodes)");
        this.titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Member Filtering (nodes to exclude from view)");
        this.border1 = BorderFactory.createLineBorder(Color.black, 2);
        this.titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Compile Options");
        this.titledBorder5 = new TitledBorder("");
        this.border2 = BorderFactory.createLineBorder(Color.black, 2);
        this.titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Run Options");
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder7 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), "Granularity (all nodes below selected level will be hidden)");
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder8 = new TitledBorder(this.border4, "Member Visibility");
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder9 = new TitledBorder(this.border5, "Member Modifiers");
        this.border6 = BorderFactory.createEmptyBorder();
        this.titledBorder10 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Structure View Properties");
        this.border7 = BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158));
        this.titledBorder11 = new TitledBorder(this.border7, "Member Kinds");
        this.border8 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.titledBorder12 = new TitledBorder(this.border8, "Build Paths");
        this.apply_button.setFont(new Font("Dialog", 0, 11));
        this.apply_button.setMaximumSize(new Dimension(70, 24));
        this.apply_button.setMinimumSize(new Dimension(63, 24));
        this.apply_button.setPreferredSize(new Dimension(70, 24));
        this.apply_button.setText("Apply");
        this.apply_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.apply_button_actionPerformed(e);
            }
        });
        this.cancel_button.setFont(new Font("Dialog", 0, 11));
        this.cancel_button.setMaximumSize(new Dimension(70, 24));
        this.cancel_button.setMinimumSize(new Dimension(67, 24));
        this.cancel_button.setPreferredSize(new Dimension(70, 24));
        this.cancel_button.setText("Cancel");
        this.cancel_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.cancel_button_actionPerformed(e);
            }
        });
        this.ok_button.setFont(new Font("Dialog", 0, 11));
        this.ok_button.setMaximumSize(new Dimension(70, 24));
        this.ok_button.setMinimumSize(new Dimension(49, 24));
        this.ok_button.setPreferredSize(new Dimension(70, 24));
        this.ok_button.setText("OK");
        this.ok_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionsFrame.this.ok_button_actionPerformed(e);
            }
        });
        this.main_tabbedPane.setFont(new Font("Dialog", 0, 11));
        this.titledBorder1.setTitle("Ordering (sort order of nodes)");
        this.titledBorder1.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder2.setTitle("Associations (navigeable relations between structure nodes)");
        this.titledBorder2.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder3.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder6.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder5.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder4.setTitle("Compiler Flags");
        this.titledBorder4.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder7.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder8.setTitle("Access Modifiers");
        this.titledBorder8.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder9.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder10.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder11.setTitleFont(new Font("Dialog", 0, 11));
        this.titledBorder12.setTitleFont(new Font("Dialog", 0, 11));
        this.about_panel.setLayout(this.borderLayout9);
        this.jPanel1.setLayout(this.borderLayout10);
        this.about_editorPane.setBackground(UIManager.getColor("OptionPane.background"));
        this.about_editorPane.setFont(new Font("Dialog", 0, 11));
        this.about_editorPane.setEditable(false);
        this.about_panel.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.about_editorPane, "Center");
        this.main_tabbedPane.add((Component)this.about_panel, "About AJDE");
        this.getContentPane().add((Component)this.button_panel, "South");
        this.button_panel.add((Component)this.ok_button, null);
        this.button_panel.add((Component)this.cancel_button, null);
        this.button_panel.add((Component)this.apply_button, null);
        this.getContentPane().add((Component)this.main_tabbedPane, "Center");
    }
}

