/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.List;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.ajde.ui.AbstractIconRegistry;
import org.aspectj.ajde.ui.StructureViewNode;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureNode;

public abstract class StructureViewNodeFactory {
    private AbstractIconRegistry iconRegistry;

    public StructureViewNodeFactory(AbstractIconRegistry iconRegistry) {
        this.iconRegistry = iconRegistry;
    }

    public StructureViewNode createNode(StructureNode node) {
        return this.createNode(node, null);
    }

    public StructureViewNode createNode(StructureNode node, List children) {
        AbstractIcon icon;
        if (node instanceof ProgramElementNode) {
            ProgramElementNode pNode = (ProgramElementNode)node;
            icon = this.iconRegistry.getStructureIcon(pNode.getProgramElementKind(), pNode.getAccessibility());
        } else if (node instanceof RelationNode) {
            RelationNode relationNode = (RelationNode)node;
            icon = this.iconRegistry.getRelationIcon(relationNode.getRelation());
        } else if (node instanceof LinkNode) {
            LinkNode linkNode = (LinkNode)node;
            icon = this.iconRegistry.getStructureIcon(linkNode.getProgramElementNode().getProgramElementKind(), linkNode.getProgramElementNode().getAccessibility());
        } else {
            icon = new AbstractIcon(null);
        }
        return this.createConcreteNode(node, icon, children);
    }

    protected abstract StructureViewNode createConcreteNode(StructureNode var1, AbstractIcon var2, List var3);
}

