/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.EditorAdapter;
import org.aspectj.ajde.EditorListener;
import org.aspectj.ajde.ui.swing.BasicEditor;
import org.aspectj.asm.SourceLocation;

public class EditorManager {
    private EditorAdapter editor = null;
    private BasicEditor basicEditor = null;
    private ArrayList editorListeners = new ArrayList();
    private Vector editors = new Vector();
    private JPanel editor_panel = null;
    private Box editors_box = Box.createVerticalBox();

    public EditorManager(EditorAdapter ajdeEditor) {
        if (ajdeEditor instanceof BasicEditor) {
            this.basicEditor = (BasicEditor)ajdeEditor;
            this.editors.add(this.basicEditor);
            this.editors_box.add(this.basicEditor.getPanel());
            this.editor_panel = new JPanel(new BorderLayout());
            this.editor_panel.add((Component)this.editors_box, "Center");
        } else {
            this.editors.add(ajdeEditor);
            this.editor = ajdeEditor;
        }
    }

    public void addListener(EditorListener editorListener) {
        this.editorListeners.add(editorListener);
    }

    public void removeListener(EditorListener editorListener) {
        ((AbstractCollection)this.editorListeners).remove(editorListener);
    }

    public void notifyCurrentFileChanged(String filePath) {
        Iterator it = ((AbstractList)this.editorListeners).iterator();
        while (it.hasNext()) {
            ((EditorListener)it.next()).currentFileChanged(filePath);
        }
    }

    public void addViewForSourceLine(final String filePath, final int lineNumber) {
        if (this.basicEditor == null) {
            return;
        }
        this.editors_box.remove(this.basicEditor.getPanel());
        final BasicEditor newEditor = new BasicEditor();
        this.editors.add(newEditor);
        Runnable update = new Runnable(){

            public void run() {
                EditorManager.this.editors_box.add(newEditor.getPanel());
                newEditor.showSourceLine(filePath, lineNumber, true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            update.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(update);
            }
            catch (Exception e) {
                Ajde.getDefault().getErrorHandler().handleError("Could not add view for source line.", e);
            }
        }
    }

    public String getCurrFile() {
        if (this.basicEditor != null) {
            return this.basicEditor.getCurrFile();
        }
        return this.editor.getCurrFile();
    }

    public void showSourceLine(SourceLocation sourceLocation, boolean highlight) {
        if (sourceLocation != null) {
            this.showSourceLine(sourceLocation.getSourceFilePath(), sourceLocation.getLineNumber(), highlight);
        }
    }

    public void showSourceLine(String filePath, int lineNumber, boolean highlight) {
        if (this.editors.size() > 1) {
            this.editors_box.removeAll();
            this.editors_box.add(this.basicEditor.getPanel());
            this.editors.removeAllElements();
            this.editors.add(this.basicEditor);
        }
        if (this.basicEditor != null) {
            this.basicEditor.showSourceLine(filePath, lineNumber, highlight);
        } else {
            this.editor.showSourceLine(filePath, lineNumber, highlight);
        }
    }

    public void pasteToCaretPos(String text) {
        if (this.basicEditor != null) {
            this.basicEditor.pasteToCaretPos(text);
        } else {
            this.editor.pasteToCaretPos(text);
        }
    }

    public void showSourcelineAnnotation(String filePath, int lineNumber, List items) {
        this.editor.showSourcelineAnnotation(filePath, lineNumber, items);
    }

    public void saveContents() {
        try {
            Iterator it = ((AbstractList)this.editors).iterator();
            while (it.hasNext()) {
                ((EditorAdapter)it.next()).saveContents();
            }
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Editor could not save the current file.", ioe);
        }
    }

    public JPanel getEditorPanel() {
        if (this.editor_panel != null) {
            return this.editor_panel;
        }
        return this.basicEditor.getPanel();
    }
}

