;; compatibility file for drscheme.

;; switch to course directory:
; (define old-working-directory (current-directory))
; (current-directory "/course/com3351/interps")

;; a better version, due to Matthew Flatt:

(require-library "pretty.ss")

(let ([p pretty-print])
  (current-namespace (scheme-report-environment 5))
  (global-defined-value 'pretty-print p))
  
;; save the nicer ambient behavior
; (define ambient-printf #%printf)

(define interps-directory "/course/com3351/interps/")

;; load the defaults
(load (string-append interps-directory "r5rs.scm"))

;; load pretty-printer for show-define-datatypes
(set! sllgen:pretty-print pretty-print)
(set! eopl:pretty-print pretty-print)
(set! define-datatype:pretty-print pretty-print)

;; better behavior for error
(define sllgen:error-stop 
  (lambda () (error 'eopl-error-stop)))

(load (string-append interps-directory "sllgen.scm"))
(load (string-append interps-directory "define-datatype.scm"))
(load (string-append interps-directory "test-harness.scm"))
(load (string-append interps-directory "test-suite.scm"))

; (current-directory old-working-directory)
