;; This is 6-5.scm: flat methods

(define oop:time-stamp "Time-stamp: <2000-03-07 09:53:33 dfried>")
; (define oop:time-stamp "Time-stamp: <99/11/21 08:03:07 dfried>")
; (define oop:time-stamp "Time-stamp: <99/11/18 06:22:38 dfried>")

;; Mon Nov 15 13:06:37 1999 initial version, from Dan's message

(let ((version "99-12")
      (date  (substring oop:time-stamp 13 30)))
  (printf "6-5.scm: flat methods version ~a ~a~%"
    version date))

(define test-all
  (lambda ()
    (test-groups '(functional oop-with-inh))))

(define test-oo
  (lambda ()
    (test-groups '(oop-with-inh))))

;;;;;;;;;;;;;;;; relevant lines from basis.scm ;;;;;;;;;;;;;;;;

; (define eval-program 
;   (lambda (pgm)
;     (cases program pgm
;       (a-program (class-decls body)
;         (elaborate-class-decls! class-decls) ;; new for ch6
;         (eval-expression body (init-env))))))

;;; new lines in eval-expression:
;;;
;       (new-object-exp (class-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (new-object class-name)))
;           (find-method-and-apply 'initialize class-name obj args)
;           obj))

;       (method-app-exp (obj-exp method-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (eval-expression obj-exp env)))
;           (find-method-and-apply
;             method-name (object->class-name obj) obj args)))

;       (super-call-exp (method-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (apply-env env 'self)))
;           (find-method-and-apply method-name
; 	      (apply-env env '%super) obj args)))

;;;;;;;;;;;;;;;; classes ;;;;;;;;;;;;;;;;

(define-datatype class class?
  (a-class
    (class-name symbol?)  
    (super-name symbol?) 
    (field-length integer?)  
    (field-ids (list-of symbol?))
    (methods method-environment?)))

;;;; constructing classes

(define elaborate-class-decls!
  (lambda (class-decls)
    (for-each elaborate-class-decl! class-decls)))

(define elaborate-class-decl!
  (lambda (c-decl)
    (let ((super-name (class-decl->super-name c-decl)))
      (let ((field-ids  (append
                          (class-name->field-ids super-name)
                          (class-decl->field-ids c-decl))))
        (add-to-class-env!
          (a-class
            (class-decl->class-name c-decl)
            super-name
            (+ (class-name->field-length super-name)
               (length (class-decl->field-ids c-decl)))
            field-ids
            (roll-up-method-decls c-decl super-name field-ids)))))))

(define roll-up-method-decls            ; 6-5
  (lambda (c-decl super-name field-ids)
    (let ((super-name (class-decl->super-name c-decl)))
      (merge-methods
        (class-name->methods super-name)
        (map
          (lambda (m-decl)
            (a-method m-decl super-name field-ids))
          (class-decl->method-decls c-decl))))))

(define merge-methods                   ; 6-5
  (lambda (super-methods methods)
    (cond
      ((null? super-methods) methods)
      (else
        (let ((overriding-method
                (lookup-method
		  (method->method-name (car super-methods))
		  methods)))
          (if overriding-method
            (cons overriding-method
              (merge-methods (cdr super-methods)
                (remove-method overriding-method methods)))
            (cons (car super-methods)
              (merge-methods (cdr super-methods)
                 methods))))))))

(define remove-method remq)             ; 6-5

;;;;;;;;;;;;;;;; objects ;;;;;;;;;;;;;;;;

;; an object is now just a single part, with a vector representing the
;; managed storage for the all the fields. 

(define-datatype object object? 
  (an-object
    (class-name symbol?)
    (fields vector?)))

(define new-object                      ; 6-3
  (lambda (class-name)
    (an-object
      class-name
      (make-vector (class-name->field-length class-name))))) ; 6-4

;;;;;;;;;;;;;;;; methods ;;;;;;;;;;;;;;;;

(define-datatype method method?
  (a-method
    (m-decl method-decl?)
    (s-name symbol?)
    (field-ids (list-of symbol?))))

(define find-method-and-apply           ; same as in 6-2
  (lambda (m-name host-name self args)  ; 6-5: no more loop
    (let ((method (lookup-method m-name ; m-decl -> method
                    (class-name->methods host-name))))
      (if method
          (apply-method method host-name self args)
          (error 'apply-method "No method for name ~s" m-name)))))

(define apply-method                    ; 6-3
  (lambda (method host-name self args)
    (eval-expression (method->body method) ; 6-4 method-decl -> method
      (extend-env
        (cons '%super (cons 'self (method->ids method))) ; 6-4
                                        ; method-decl -> method
        (cons
          (method->super-name method) ;; 6-5
          (cons self args))
        (extend-env-with-vector         
          (method->field-ids method) ; 6-4
          (object->fields self)
          (empty-env))))))

(define env-find-position               ; 6-3
  (lambda (name symbols)
    (list-find-last-position name symbols)))

;;;;;;;;;;;;;;;; method environments ;;;;;;;;;;;;;;;;

(define method-environment? (list-of method?)) 

(define lookup-method                   ; 6-4 method-decl => method
  (lambda (m-name methods)              ; 6-5a: methods now a vector
    (cond
      ((null? methods) #f)
      ((eqv? m-name (method->method-name (car methods)))
       (car methods))
      (else (lookup-method m-name (cdr methods))))))

;;;;;;;;;;;;;;;; class environments ;;;;;;;;;;;;;;;;

;;; we'll just use the list of class-decls.

(define *class-env* '())

(define add-to-class-env!
  (lambda (class)
    (set! *class-env* (cons class *class-env*))))

(define lookup-class                    ; 6-4 class-decl => class
  (lambda (name)
    (let loop ((env *class-env*))
      (cond
        ((null? env) (error 'lookup-class "unknown class ~s" name))
        ((eqv? (class->class-name (car env)) name) (car env))
        (else (loop (cdr env)))))))

;;;;;;;;;;;;;;;; selectors ;;;;;;;;;;;;;;;;

(define class->class-name
  (lambda (c-struct)
    (cases class c-struct
      (a-class (class-name super-name field-length
		      field-ids
		      methods)
	class-name))))

(define class->super-name
  (lambda (c-struct)
    (cases class c-struct
      (a-class (class-name super-name field-length
		      field-ids
		      methods)
	super-name))))

(define class->field-length
  (lambda (c-struct)
    (cases class c-struct
      (a-class (class-name super-name field-length
		      field-ids
		      methods)
	field-length))))

(define class->field-ids
  (lambda (c-struct)
    (cases class c-struct
      (a-class (class-name super-name field-length
		      field-ids
		      methods)
	field-ids))))

(define class->methods
  (lambda (c-struct)
    (cases class c-struct
      (a-class (class-name super-name field-length
		      field-ids
		      methods)
        methods))))

(define object->class-name
  (lambda (obj)
    (cases object obj
      (an-object (class-name fields)
        class-name))))

(define object->class-name
  (lambda (obj)
    (cases object obj
      (an-object (class-name fields)
        class-name))))

(define object->fields
  (lambda (obj)
    (cases object obj
      (an-object (class-decl fields)
        fields))))

(define object->class-decl
  (lambda (obj)
    (lookup-class (object->class-name obj))))

(define part->class-decl
  (lambda (part)
    (lookup-class (part->class-name part))))

(define object->field-ids
  (lambda (object)
    (class->field-ids
      (object->class-decl object))))

(define class-name->super-name
  (lambda (class-name)
    (class->super-name (lookup-class class-name))))

(define class-name->field-ids
  (lambda (class-name)
    (if (eqv? class-name 'object) '()
      (class->field-ids (lookup-class class-name)))))

(define class-name->methods
  (lambda (class-name)
    (if (eqv? class-name 'object) '()
      (class->methods (lookup-class class-name)))))

(define class-name->field-length
  (lambda (class-name)
    (if (eqv? class-name 'object)
        0
        (class->field-length (lookup-class class-name)))))

(define method->method-decl
  (lambda (meth)
    (cases method meth
      (a-method (meth-decl super-name field-ids) meth-decl))))

(define method->super-name
  (lambda (meth)
    (cases method meth
      (a-method (meth-decl super-name field-ids) super-name))))

(define method->field-ids
  (lambda (meth)
    (cases method meth
      (a-method (method-decl super-name field-ids) field-ids))))

(define method->method-name
  (lambda (method)
    (method-decl->method-name (method->method-decl method))))

(define method->body
  (lambda (method)
    (method-decl->body (method->method-decl method))))

(define method->ids
  (lambda (method)
    (method-decl->ids (method->method-decl method))))
