;; This is 6-3.scm: flat fields

(define oop:time-stamp "Time-stamp: <2000-03-07 09:51:23 dfried>")
; (define oop:time-stamp "Time-stamp: <99/11/21 08:03:07 dfried>")
; (define oop:time-stamp "Time-stamp: <99/11/18 06:22:38 dfried>")

;; Mon Nov 15 13:06:37 1999 initial version, from Dan's message

(let ((version "99-12")
      (date  (substring oop:time-stamp 13 30)))
  (printf "6-3.scm: flat fields version ~a ~a~%"
    version date))

(define test-all
  (lambda ()
    (test-groups '(functional oop-with-inh))))

(define test-oo
  (lambda ()
    (test-groups '(oop-with-inh))))

;;;;;;;;;;;;;;;; relevant lines from basis.scm ;;;;;;;;;;;;;;;;

; (define eval-program 
;   (lambda (pgm)
;     (cases program pgm
;       (a-program (class-decls body)
;         (elaborate-class-decls! class-decls) ;; new for ch6
;         (eval-expression body (init-env))))))

;;; new lines in eval-expression:
;;;
;       (new-object-exp (class-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (new-object class-name)))
;           (find-method-and-apply 'initialize class-name obj args)
;           obj))

;       (method-app-exp (obj-exp method-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (eval-expression obj-exp env)))
;           (find-method-and-apply
;             method-name (object->class-name obj) obj args)))

;       (super-call-exp (method-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (apply-env env 'self)))
;           (find-method-and-apply method-name
; 	      (apply-env env '%super) obj args)))

;;;;;;;;;;;;;;;; classes ;;;;;;;;;;;;;;;;

;;; classes are represented by their class-decls.

(define class? class-decl?)             ; not used

;;;;;;;;;;;;;;;; objects ;;;;;;;;;;;;;;;;

;; an object is now just a single part, with a vector representing the
;; managed storage for the all the fields. 

(define-datatype object object? 
  (an-object
    (class-name symbol?)
    (fields vector?)))

(define new-object                      ; 6-3
  (lambda (class-name)
    (an-object
      class-name
      (make-vector (roll-up-field-length class-name)))))

(define roll-up-field-length            ; 6-3
  (lambda (class-name)
    (if (eq? class-name 'object)
        0
        (+
          (roll-up-field-length (class-name->super-name class-name))
          (length (class-name->field-ids class-name))))))

;;;;;;;;;;;;;;;; methods ;;;;;;;;;;;;;;;;

(define find-method-and-apply           ; same as in 6-2
  (lambda (m-name host-name self args)
    (let loop ((host-name host-name))
      (if (eqv? host-name 'object)
          (error 'apply-method "No method for name ~s" m-name)
          (let ((m-decl (lookup-method-decl m-name
                      (class-name->method-decls host-name))))
            (if m-decl 
                (apply-method m-decl host-name self args)
                (loop (class-name->super-name host-name))))))))

(define apply-method                    ; 6-3
  (lambda (m-decl host-name self args)
    (eval-expression (method-decl->body m-decl)
      (extend-env
        (cons '%super (cons 'self (method-decl->ids m-decl)))
        (cons (class-name->super-name host-name) (cons self args))
        (extend-env-with-vector         ; ttnew4 6-3
          (roll-up-field-ids host-name)
          (object->fields self)
          (empty-env))))))

(define roll-up-field-ids               ; 6-3
  (lambda (class-name)
    (if (eqv? class-name 'object)
        '()
        (append
          (roll-up-field-ids (class-name->super-name class-name))
          (class-name->field-ids class-name)))))

(define env-find-position               ; 6-3
  (lambda (name symbols)
    (list-find-last-position name symbols)))

;;;;;;;;;;;;;;;; method environments ;;;;;;;;;;;;;;;;

(define lookup-method-decl 
  (lambda (m-name method-decls)
    (cond
      ((null? method-decls) #f)
      ((eqv? m-name (method-decl->method-name (car method-decls)))
       (car method-decls))
      (else (lookup-method-decl m-name (cdr method-decls))))))

;;;;;;;;;;;;;;;; class environments ;;;;;;;;;;;;;;;;

;;; we'll just use the list of class-decls.

(define *class-env* '())

(define elaborate-class-decls!
  (lambda (class-decls)
    (set! *class-env* class-decls)))

(define lookup-class
  (lambda (name)
    (let loop ((env *class-env*))
      (cond
        ((null? env) (error 'lookup-class "unknown class ~s" name))
        ((eqv? (class-decl->class-name (car env)) name) (car env))
        (else (loop (cdr env)))))))

;;;;;;;;;;;;;;;; selectors ;;;;;;;;;;;;;;;;

(define object->class-name
  (lambda (obj)
    (cases object obj
      (an-object (class-name fields)
        class-name))))

(define object->fields
  (lambda (obj)
    (cases object obj
      (an-object (class-decl fields)
        fields))))

(define object->class-decl
  (lambda (obj)
    (lookup-class (object->class-name obj))))

(define part->class-decl
  (lambda (part)
    (lookup-class (part->class-name part))))

(define object->field-ids
  (lambda (object)
    (class-decl->field-ids
      (object->class-decl object))))

(define class-name->super-name
  (lambda (class-name)
    (class-decl->super-name (lookup-class class-name))))

(define class-name->field-ids
  (lambda (class-name)
    (class-decl->field-ids (lookup-class class-name))))

(define class-name->field-ids
  (lambda (class-name)
    (class-decl->field-ids (lookup-class class-name))))

(define class-name->method-decls
  (lambda (class-name)
    (class-decl->method-decls (lookup-class class-name))))