;;; This code cannot be uptodate.


;; This is 6-2.scm: uses class-decls, list-of-parts representation

(define oop:time-stamp "Time-stamp: <2000-03-07 09:50:13 dfried>")
; (define oop:time-stamp "Time-stamp: <99/11/21 07:59:16 dfried>")
; (define oop:time-stamp "Time-stamp: <99/11/18 06:14:36 dfried>")

;; Mon Nov 15 13:06:37 1999 initial version, from Dan's message

(let ((version "99-12")
      (date  (substring oop:time-stamp 13 29)))
  (printf "6-2.scm: simplest inheritance version ~a ~a~%"
    version date))

(define test-all
  (lambda ()
    (test-groups '(functional oop-with-inh))))

(define test-oo
  (lambda ()
    (test-groups '(oop-with-inh))))

;;;;;;;;;;;;;;;; relevant lines from basis.scm ;;;;;;;;;;;;;;;;

; (define eval-program 
;   (lambda (pgm)
;     (cases program pgm
;       (a-program (class-decls body)
;         (elaborate-class-decls! class-decls) ;; new for ch6
;         (eval-expression body (init-env))))))

;;; new lines in eval-expression:

;       (new-object-exp (class-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (new-object class-name)))
;           (find-method-and-apply 'initialize class-name obj args)
;           obj))

;       (method-app-exp (obj-exp method-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (eval-expression obj-exp env)))
;           (find-method-and-apply
;             method-name (object->class-name obj) obj args)))

;       (super-call-exp (method-name rands)
;         (let ((args (eval-rands rands env))
;               (obj (apply-env env 'self)))
;           (find-method-and-apply method-name
;             (apply-env env '%super) obj args)))


;;;;;;;;;;;;;;;; classes ;;;;;;;;;;;;;;;;

;;; classes are represented by their class-decls.

(define class? class-decl?)             ; not used

;;;;;;;;;;;;;;;; objects ;;;;;;;;;;;;;;;;

;; an object is a list of parts.  An part is a class-declaration and a
;; vector representing the managed storage for the fields of that class.

(define-datatype part part? 
  (a-part
    (class-name symbol?)
    (fields vector?)))

; (define new-object
;   (lambda (class-name)
;     (if (eq? class-name 'object)
;         '()
;         (let ((c-decl (lookup-class class-name)))
;           (let ((super-name (class-decl->super-name c-decl))
;                 (field-decls (class-decl->field-decls c-decl)))
;             (cons
;               (a-part
;                 (class-decl->class-name c-decl)
;                 (make-vector (length field-decls)))
;               (new-object super-name)))))))

(define new-object
  (lambda (class-name)
    (if (eq? class-name 'object)
        '()
        (let ((c-decl (lookup-class class-name)))
          (cons
            (make-first-part c-decl)
            (new-object (class-decl->super-name c-decl)))))))

(define make-first-part
  (lambda (c-decl)
    (a-part
      (class-decl->class-name c-decl)
      (make-vector (length (class-decl->field-ids c-decl))))))

;;;;;;;;;;;;;;;; methods ;;;;;;;;;;;;;;;;

;;; methods are represented by their declarations.  They are closed
;;; over their fields at application time, by apply-method.

(define find-method-and-apply
  (lambda (m-name host-name self args)
    (let loop ((host-name host-name))
      (if (eqv? host-name 'object)
          (error 'apply-method "No method for name ~s" m-name)
          (let ((m-decl (lookup-method-decl m-name
			  (class-name->method-decls host-name))))
            (if m-decl 
                (apply-method m-decl host-name self args)
                (loop (class-name->super-name host-name))))))))

(define find-method-and-apply
  (lambda (m-name host-name self args)
    (if (eqv? host-name 'object)
        (error 'apply-method "No method for name ~s" m-name)
        (let ((m-decl (lookup-method-decl m-name
                        (class-name->method-decls host-name))))
          (if m-decl 
              (apply-method m-decl host-name self args)
              (find-method-and-apply m-name 
                (class-name->super-name host-name)
                self args))))))

(define align-object
  (lambda (parts class-name)
    (if (eqv? (part->class-name (car parts)) class-name)
        parts
        (align-object (cdr parts) class-name))))

(define apply-method
  (lambda (m-decl host-name self args)
    (let ((visible-parts (align-object self host-name)))
      (eval-expression (method-decl->body m-decl)
        (extend-env
          (cons '%super
                (cons 'self
                      (method-decl->ids m-decl)))
          (cons (class-name->super-name host-name)
                (cons self
                      args))
          (build-field-env visible-parts))))))

(define build-field-env
  (lambda (parts)
    (if (null? parts)
        (empty-env)
        (extend-env-with-vector
          (part->field-ids (car parts))
          (part->fields    (car parts))
          (build-field-env (cdr parts))))))

;;;;;;;;;;;;;;;; method environments ;;;;;;;;;;;;;;;;

;; find a method in a list of method-decls, else return #f

(define lookup-method-decl 
  (lambda (m-name method-decls)
    (cond
      ((null? method-decls) #f)
      ((eqv? m-name (method-decl->method-name (car method-decls)))
       (car method-decls))
      (else (lookup-method-decl m-name (cdr method-decls))))))
      
;;;;;;;;;;;;;;;; class environments ;;;;;;;;;;;;;;;;

;;; we'll just use the list of class-decls.

(define *class-env* '())

(define elaborate-class-decls!
  (lambda (class-decls)
    (set! *class-env* class-decls)))

(define lookup-class
  (lambda (name)
    (let loop ((env *class-env*))
      (cond
        ((null? env) (error 'lookup-class "unknown class ~s" name))
        ((eqv? (class-decl->class-name (car env)) name) (car env))
        (else (loop (cdr env)))))))

;;;;;;;;;;;;;;;; selectors of all sorts ;;;;;;;;;;;;;;;;

(define part->class-name
  (lambda (prt)
    (cases part prt
      (a-part (class-name fields)
        class-name))))

(define part->fields
  (lambda (prt)
    (cases part prt
      (a-part (class-name fields)
        fields))))

(define part->field-ids
  (lambda (part)
    (class-decl->field-ids (part->class-decl part))))

(define part->class-decl
  (lambda (part)
    (lookup-class (part->class-name part))))

(define part->method-decls
  (lambda (part)
    (class-decl->method-decls (part->class-decl part))))

(define part->super-name
  (lambda (part)
    (class-decl->super-name (part->class-decl part))))

(define class-name->method-decls
  (lambda (class-name)
    (class-decl->method-decls (lookup-class class-name))))

(define class-name->super-name
  (lambda (class-name)
    (class-decl->super-name (lookup-class class-name))))

(define object->class-name
  (lambda (parts)
    (part->class-name (car parts))))