;;; mp5-tests.scm
;;; 
;;; Time-stamp: <2004-02-12 20:54:36 wand>

(add-typed-test! 'listof 'list-1 "list(11,22,33)"
  '(listof int) '(11 22 33))

(add-typed-test! 'listof 'list-of-lists-1
  "list(list(11,22),list(33))"
  '(listof (listof int)) '((11 22) (33)))

(add-typed-test! 'listof 'list-broken-1
  "list(11,false)"
  'error '(11 0))

(add-typed-test! 'listof 'list-broken-2
  "list(list(11,22),list(false))"
  'error '((11 22) (0)))

(add-typed-test! 'listof 'test-emptylist-1
  "emptylist[bool]"
  '(listof bool) '())

(add-typed-test! 'listof 'type-of-cons-1
  "proc(int x, listof int y) cons(x,y)"
  '(int * (listof int) -> (listof int)) 'dontrun)

(add-typed-test! 'listof 'test-emptylist-2
  "(proc(int x) let y = emptylist[int] in cons(x,y) 
    33)"
'(listof int) '(33))

(add-typed-test! 'listof 'test-car-1 "
(proc (listof int x) car(x)
 list(11,22,33))"
'int 11)

(add-typed-test! 'listof 'list-ops-with-multiple-types-1
  "let f = proc(int x, listof int y) cons(x,y)
       g = proc(bool x, listof bool y) cons(x,y)
   in if car((g true emptylist[bool])) 
      then car(cdr(cons(2,(f 3 emptylist[int]))))
      else 4"
  'int 3)

(add-typed-test! 'listof 'map-1 "
letrec
 listof bool map1 ((int -> bool) f, listof int x) 
   = if null?(x) then emptylist[bool]
                 else cons( (f car(x)),
                            (map1 f cdr(x)) )
in (map1
     proc (int x) zero?(x)
     list(22,0,33,44,0))"
'(listof bool) '(0 1 0 0 1))

(add-typed-test! 'listof 'map-2 "
let map1 = proc ((int -> bool) f, listof int x) 
            letrec 
             listof bool innerloop (listof int x) 
              = if null?(x) 
                 then emptylist[bool]
                 else cons( (f car(x)),
                            (innerloop cdr(x)) )
             in (innerloop x)
in (map1
     proc (int x) zero?(x)
     list(22,0,33,44,0))"
'(listof bool) '(0 1 0 0 1))

