(let ((time-stamp "Time-stamp: <2004-03-06 16:19:43 wand>"))
  (eopl:printf "letcc.scm+explicit-store.scm: ~a~%"
    (substring time-stamp 13 29)))

;;; test with (run-all)

;; include these for PLT
;; (load "test-harness.scm")
;; (load "test-suite.scm")

;;;;;;;;;;;;;;;; syntax ;;;;;;;;;;;;;;;;

(define the-lexical-spec
  '((whitespace (whitespace) skip)
    (comment ("%" (arbno (not #\newline))) skip)
    (identifier
      (letter (arbno (or letter digit "_" "-" "?")))
      make-symbol)
    (number (digit (arbno digit)) make-number)
    (number ("-" digit (arbno digit)) make-number)
    ))

(define the-grammar
  '((program (expression) a-program)
    (expression (number) lit-exp)
    (expression (identifier) var-exp)   

    (expression
      (primitive "(" (separated-list expression ",") ")")
      primapp-exp)
    (expression
      ("if" expression "then" expression "else" expression)
      if-exp)

    (expression
      ("proc" "(" (separated-list identifier ",") ")" expression)
      proc-exp)
    (expression
      ("(" expression (arbno expression) ")")
      app-exp)

    (expression
      ("let" (arbno identifier "=" expression) "in" expression)
      let-exp)

    (expression
      ("try" expression "handle" expression)
      try-exp)
    
    (expression
      ("raise")
      raise-exp)

    (expression
      ("letcc" identifier "in" expression)
      letcc-exp)

    (expression
      ("throw" "(" expression "," expression ")")
      throw-exp)

    (expression
      ("begin" expression (arbno ";" expression) "end")
      begin-exp)

    (expression                         ; new for 3-6
      ("letrec"
        (arbno identifier "(" (separated-list identifier ",") ")"
          "=" expression)
        "in" expression)
      letrec-exp)

    (primitive ("+")     add-prim)
    (primitive ("-")     subtract-prim)
    (primitive ("*")     mult-prim)
    (primitive ("add1")  incr-prim)
    (primitive ("sub1")  decr-prim)
    (primitive ("zero?") zero-test-prim)

    (primitive ("newref") newref-prim)
    (primitive ("deref")  deref-prim)
    (primitive ("setref") setref-prim)

    (primitive ("print")  print-prim)
    (primitive ("context?") context-test-prim)

    ))

;;;;;;;;;;;;;;;; sllgen boilerplate ;;;;;;;;;;;;;;;;

(sllgen:make-define-datatypes the-lexical-spec the-grammar)

(define show-the-datatypes
  (lambda () (sllgen:list-define-datatypes the-lexical-spec the-grammar)))

(define scan&parse
  (sllgen:make-string-parser the-lexical-spec the-grammar))

(define just-scan
  (sllgen:make-string-scanner the-lexical-spec the-grammar))

;;;;;;;;;;;;;;;; interface to test harness ;;;;;;;;;;;;;;;;

(define run
  (lambda (string)
    (eval-program (scan&parse string))))

(define eval-program
  (lambda (pgm)
    (initialize-store!)
    (cases program pgm
      (a-program (exp)
        (eval-exp-c
          exp
          (empty-env)
          (empty-context))))))

(define run-all
  (lambda ()
    (run-experiment run use-execution-outcome
      '(explicit-store cps2 letcc) all-tests equal?)))

(define run-one
  (lambda (test-name)
    (run-test run test-name)))

;;;;;;;;;;;;;;;; expressed values ;;;;;;;;;;;;;;;;

(define expval?
  (lambda (v)
    (or (number? v) (procval? v)
      (context? v)
      )))

(define-datatype procval procval?
  (closure
    (id (list-of symbol?))
    (body expression?)
    (env environment?)))

;;;;;;;;;;;;;;;; contexts ;;;;;;;;;;;;;;;;

(define-datatype context context?
  (empty-context)                       ; []

  (if-context                           ; cxt[(if (true-value? [])
                                        ; ..)]
    (true-exp expression?)
    (false-exp expression?)
    (env environment?)
    (cxt context?))

  (apply-primitive-context              ; cxt[(apply-primitive p [])]
    (prim primitive?)
    (cxt context?))

  (eval-exps1-context                   ; cxt[(cons [] (eval-exps exps
                                        ; env))]
    (exps (list-of expression?))
    (env environment?)
    (cxt context?))

  (eval-exps2-context                   ; cxt[(cons v [])]
    (val expval?)
    (cxt context?))

  (app1-context            ; cxt[(apply-procval [] (eval-exps exps env))]
    (exps (list-of expression?))
    (env environment?)
    (cxt context?))
  (app2-context                         ; cxt[(apply-procval val [])]
    (val expval?)
    (cxt context?))

  (try1-context
    (handler expression?)
    (saved-env environment?)
    (cxt context?))

  (throw1-context
    (exp2 expression?)
    (saved-env environment?)
    (cxt context?))

  (begin1-context
    (exps (list-of expression?))
    (saved-env environment?)
    (cxt context?))

  )
  
(define eval-exp-c                      ; == cxt[(eval-exp exp)]
  (lambda (exp env cxt)
    (cases expression exp
      (lit-exp (n) (apply-context cxt n))
      (var-exp (id) (apply-context cxt (apply-env env id)))
      (if-exp (e0 e1 e2)
        (eval-exp-c e0 env (if-context e1 e2 env cxt)))
      (primapp-exp (prim exps)
        (eval-exps-c exps env (apply-primitive-context prim cxt)))
      (proc-exp (ids exp)
        (apply-context cxt (closure ids exp env)))
      (app-exp (rator rands)
        (eval-exp-c rator env (app1-context rands env cxt)))

      (let-exp (ids rhss body)          ; implemented like a macro!
        (eval-exp-c
          (app-exp
            (proc-exp ids body)
            rhss)
          env
          cxt))

      (try-exp (body handler)
        (eval-exp-c body env (try1-context handler env cxt)))
      (raise-exp ()
        (apply-handler-context cxt))

      (letcc-exp (id body)
        (eval-exp-c
          body
          (extend-env (list id) (list cxt) env)
          cxt))

      (throw-exp (exp1 exp2)
        (eval-exp-c exp1 env (throw1-context exp2 env cxt)))

      (begin-exp (exp exps)
        (eval-exp-c exp env (begin1-context exps env cxt)))

      (letrec-exp (proc-names idss bodies letrec-body) 
        (eval-exp-c letrec-body
          (extend-env-recursively proc-names idss bodies env)
          cxt))

      )))

(define eval-exps-c
  (lambda (exps env cxt)
    (if (null? exps)
      (apply-context cxt '())
      (eval-exp-c (car exps) env
        (eval-exps1-context (cdr exps) env cxt)))))

(define apply-context                   ; == cxt[val]
  (lambda (cxt val)
    (cases context cxt
      (empty-context () val)
      (if-context (true-exp false-exp env cxt)
        (if (true-value? val)
          (eval-exp-c true-exp env cxt)
          (eval-exp-c false-exp env cxt)))
      (apply-primitive-context (prim cxt) ; val should be a list of expvals
        (apply-context cxt
          (apply-primitive prim val)))
      (eval-exps1-context (exps env cxt)
        (eval-exps-c exps env
          (eval-exps2-context val cxt)))
      (eval-exps2-context (oldval cxt)  ; val should be list of expvals
        (apply-context cxt (cons oldval val)))
      (app1-context (exps env cxt)
        (eval-exps-c exps env (app2-context val cxt)))
      (app2-context (proc cxt)          ; val is a list of expval here
        (if (procval? proc)
          (cases procval proc
            (closure (ids exp saved-env)
              (eval-exp-c exp (extend-env ids val saved-env) cxt)))
          (eopl:error 'apply-context
            "attempt to apply non procval ~s"
            val)))

      (try1-context (handler saved-env cxt)
        (apply-context cxt val))

      (throw1-context (exp2 env cxt)
        (if (context? val)
          (eval-exp-c exp2 env val)     ; use new context, not old one
          (eopl:error 'apply-context
            "attempt to throw to non-continuation ~s"
            val)))

      (begin1-context (exps env cxt)
        (if (null? exps)
          (apply-context cxt val)
          (eval-exp-c (car exps) env (begin1-context (cdr exps) env cxt))))

      )))

(define apply-handler-context
  (lambda (cxt)
    (cases context cxt
      ;; interesting cases:
      (empty-context ()
        (eopl:error 'apply-handler-context "uncaught exception!"))
      (try1-context (handler saved-env cxt)
        (eval-exp-c handler saved-env cxt))

      ;; everybody else just searches up the context chain.
      (if-context (true-exp false-exp env cxt)
        (apply-handler-context cxt))
      (apply-primitive-context (prim cxt) 
        (apply-handler-context cxt))
      (eval-exps1-context (exps env cxt)
        (apply-handler-context cxt))
      (eval-exps2-context (oldval cxt)  
        (apply-handler-context cxt))
      (app1-context (exps env cxt)
        (apply-handler-context cxt))
      (app2-context (proc cxt)          ; val is a list of expval here
        (apply-handler-context cxt))
      (throw1-context (exp2 env cxt)
        (apply-handler-context cxt))
      
      (begin1-context (exps env cxt)
        (apply-handler-context cxt))
      )))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
      
(define apply-primitive
  (lambda (prim args)
    (cases primitive prim
      (add-prim  () (+ (car args) (cadr args)))
      (subtract-prim () (- (car args) (cadr args)))
      (mult-prim  () (* (car args) (cadr args)))
      (incr-prim  () (+ (car args) 1))
      (decr-prim  () (- (car args) 1))
      (zero-test-prim () (if (zero? (car args)) 1 0))

      (newref-prim () (newref (car args)))
      (deref-prim ()
        (let ((v (car args)))
          (if (reference? v)
            (deref v)
            (eopl:error 'eval-expression
              "Attempt to dereference non-reference ~s"
              v))))
      (setref-prim ()
        (let ((cell (car args))
              (val (cadr args)))
          (if (reference? cell)
            (begin
              (setref! cell val)
              1)
            (eopl:error 'eval-expression
              "Attempt to assign to  non-reference ~s"
              v))))
      (print-prim ()
        (begin
          (eopl:printf "~a~%" (car args))
          1))
      
      (context-test-prim () (if (context? (car args)) 1 0))

      )))

(define true-value?
  (lambda (x)
    (not (zero? x))))

;;;;;;;;;;;;;;;; references and the store ;;;;;;;;;;;;;;;;

;;; world's dumbest model of the store:  the store is a list and a
;;; reference is number which denotes a position in the list.

(define the-store '())

(define empty-store
  (lambda () '()))

(define initialize-store!
  (lambda ()
    (set! the-store (empty-store))))

(define reference? integer?)

(define newref
  (lambda (val)
    (let ((next-ref (length the-store)))
      (set! the-store
        (append the-store (list val)))
      next-ref))) ; YUCK!

(define deref 
  (lambda (loc) (list-ref the-store loc)))

(define setref!                          ; YUCK!
  (lambda (loc0 val)
    (set! the-store
      (let recur ((store the-store) (loc loc0))
        (cond
          ((null? store)
           (eopl:error 'setref
             "illegal reference ~s in store ~s"
             loc0 the-store))
          ((zero? loc)
           (cons val (cdr store)))
          (else
            (cons
              (car store)
              (recur (cdr store) (- loc 1)))))))))

;;;;;;;;;;;;;;;; environments ;;;;;;;;;;;;;;;;

;;; from 3-5.scm

(define-datatype environment environment?
  (empty-env-record)
  (extended-env-record
    (syms (list-of symbol?))
    (vec vector?)              ; can use this for anything.
    (env environment?))
  )

(define empty-env
  (lambda ()
    (empty-env-record)))

(define extend-env
  (lambda (syms vals env)
    (extended-env-record syms (list->vector vals) env)))

(define apply-env
  (lambda (env sym)
    (cases environment env
      (empty-env-record ()
        (eopl:error 'apply-env "No binding for ~s" sym))
      (extended-env-record (syms vals env)
        (let ((position (rib-find-position sym syms)))
          (if (number? position)
              (vector-ref vals position)
              (apply-env env sym)))))))

(define extend-env-recursively
  (lambda (proc-names idss bodies old-env)
    (let ((len (length proc-names)))
      (let ((vec (make-vector len)))
        (let ((env (extended-env-record
                     proc-names vec old-env)))
          (for-each
            (lambda (pos ids body)
              (vector-set! vec pos (closure ids body env)))
            (iota len) idss bodies)
          env)))))

(define rib-find-position 
  (lambda (sym los)
    (list-find-position sym los)))

(define list-find-position
  (lambda (sym los)
    (list-index (lambda (sym1) (eqv? sym1 sym)) los)))

(define list-index
  (lambda (pred ls)
    (cond
      ((null? ls) #f)
      ((pred (car ls)) 0)
      (else (let ((list-index-r (list-index pred (cdr ls))))
              (if (number? list-index-r)
                (+ list-index-r 1)
                #f))))))

(define iota
  (lambda (end)
    (let loop ((next 0))
      (if (>= next end) '()
        (cons next (loop (+ 1 next)))))))


;;;;;;;;;;;;;;;; local tests ;;;;;;;;;;;;;;;;

(add-test! 'cps2 'positive-const "11" 11)

(add-test! 'cps2 'negative-const "-33" -33)

(add-test! 'cps2 'simple-arith-1 "-(44,33)" 11)

(add-test! 'cps2 'nested-arith-left "-(-(44,33),22)" -11)

(add-test! 'cps2 'nested-arith-right "-(55, -(22,11))" 44)

(add-test! 'cps2 'simple-app "(proc (x) x  11)" 11)

(add-test! 'cps2 'simple-curried-app "((proc (x) proc (y) -(x,y) 5) 6)" -1)

(add-test! 'cps2 'pass-a-procedure "(proc (f) (f 11) proc (x) x)" 11)

(add-test! 'cps2 'check-shadowing "(proc (f) (f 11) proc (f) f)" 11)

;; from lang3-5:

(add-test! 'cps2 'pgm1 "1" 1)

(add-test! 'lang3-5 'pgm2 "add1(x)" 'error)

;; this should raise an error
(add-test! 'lang3-5 'unbound-variable "foo" 'error)

; (add-test! 'cps2 'primitive-app-2 "+(x,3)" 13)

(add-test! 'cps2 'pgm3 "if zero?(1) then 3 else 4" 4)

(add-test! 'cps2 'pgm4 "if zero?(0) then 3 else 4" 3)

(add-test! 'cps2 'pgm5 "let x = 3 y = 4 in +(x,y)" 7)

(add-test! 'cps2 'nested-prim-app "+(1,*(3,4))" 13)

(add-test! 'cps2 'let-1 "let x = 5 y = 6 in +(x,y)" 11)

(add-test! 'cps2 'let-to-proc-1 "(proc (x,y) +(x,y) 5 6)" 11)

(add-test! 'cps2 'nested-let-1 "
let z = 5 x = 3
in let x = 4
       y = +(x,z)         % here x = 3
   in *(z, +(x,y))        % here x = 4"
  60)

(add-test! 'cps2 'nested-let-2 "
(proc (z,x)
 (proc (x,y) *(z, +(x,y)) 4 +(x,z))
 5 3)
" 60)

(add-test! 'cps2 'nested-let-3 "let z = let x = 3 in *(x,x) in z" 9)

(add-test! 'cps2 'bind-a-proc "let f = proc(x,y)+(x,y) in (f 3 4)" 7)

(add-test! 'cps2 'apply-a-proc "(proc(x,y)-(x,y)  4 3)" 1)


; (add-test! 'cps2 'infinite-loop "
; let fix =  proc (f)
;             let d = proc (x) proc (z) (f (x x) z)
;             in proc (n) (f (d d) n)
; in let loop = (fix proc (f,x) (f x))
;    in (loop 1)" 'dontrun)

(add-test! 'cps2 'poor-mans-letrec "
let fix =  proc (f)
            let d = proc (x) proc (z) (f (x x) z)
            in proc (n) (f (d d) n)
    t4m = proc (f,x) if x then +(4,(f -(x,1))) else 0
in let times4 = (fix t4m)
   in (times4 3)" 12)

(add-test! 'cps2 'simple-succeed "try 3 handle 4" 3)

(add-test! 'cps2 'simple-handle  "try raise handle 4" 4)

;(add-test! 'cps2 'simple-uncaught-exception "raise" 'error)

(add-test! 'cps2 'nested-handle "try +(33,raise) handle 44" 44)

(add-test! 'cps2 'test-sequencing-1
"let f = proc (x,y) raise
 in try (f 22 33) handle 44" 
44)

(add-test! 'cps2 'test-sequencing-2
"let f = proc (x) raise
 in -(44, try (f) handle 11)"
33)

(add-test! 'cps2 'propagate "try try raise handle raise handle 11" 11)

(add-test! 'cps2 'propagate-2
"let f = proc() raise
 in let g = proc() +(try (f) handle raise, 33)
 in let h = proc() try (g) handle 11
 in (h)
"
11)

(add-test! 'letcc 'simple-1 "letcc k in throw(k,3)" 3)

(add-test! 'letcc 'simple-2 "letcc k in +(44,throw(k,3))" 3)

(add-test! 'letcc 'simple-3 "+(4,letcc k in +(44,throw(k,3)))" 7)

(add-test! 'letcc 'raise-error-during-throw 
           "+(4, try letcc k in +(44,throw(raise,3)) handle 44)"
           48)


(add-test! 'letcc 'raise-error-during-throw2
   "let f = proc (k) try letcc k22 in throw(raise,3) handle 22
   in let g = proc() try letcc k11 in (f k11)
                     handle 11
   in +(4, (g))"
           26)

(add-test! 'letcc 'ordinary-throw "
   let f = proc (k) try letcc k22 in throw(k,3) handle 22
   in let g = proc() try letcc k11 in (f k11)
                     handle 11
   in +(4, (g))" 
           7)

(add-test! 'letcc 'ordinary-throw-2 "
   let f = proc (k) try letcc k22 in add1(throw(k,3)) handle 22
   in let g = proc() try letcc k11 in add1((f k11))
                     handle 11
   in +(4, (g))" 
           7)


(add-test! 'letcc 'raise-error-during-throw-2nd-arg "
   let f = proc (k) try letcc k22 in throw(k,raise) handle 22
   in let g = proc() try letcc k11 in (f k11)
                     handle 11
   in +(4, (g))"
           15)

(add-test! 'letcc 'begin-empty "begin end" 'error)

(add-test! 'letcc 'begin-1 "begin 33 end" 33)

(add-test! 'letcc 'begin-2 "begin 33; 44 end" 44)

(add-test! 'letcc 'coroutines-1 
  ;; this should print:
  ;;  > (run co1)
  ;; 100
  ;; 5
  ;; 200
  ;; -5
  ;; 101
  ;; 4
  ;; 201
  ;; -6
  ;; and then return 202
  "let p1k = newref(0) p2k = newref(0)
   in letrec p1 (n) = let yield = proc (q, n) letcc k1 
                                                    in begin 
                                                         setref(p1k, k1);
                                                         (q n)
                                                       end
                             in if context?(deref(p1k))
                                then throw(deref(p1k),n)
                                else
                                    begin
                                      print(100);
                                      print(n);
                                      (yield p2 -(0,n));
                                      print(101);
                                      print(sub1(n));
                                      (yield p2 1000)
                                     end
             p2 (n) = let yield = proc (q, n) letcc k1 
                                                    in begin 
                                                         setref(p2k, k1);
                                                         (q n)
                                                       end
                             in if context?(deref(p2k))
                                then throw(deref(p2k), n)
                                else
                                    begin
                                      print(200);
                                      print(n);
                                      (yield p1 2000);
                                      print(201);
                                      print(sub1(n));
                                      (yield p1 202);
                                      setref(999999,0)   % never executed
                                     end
       in (p1 5)"
  202)


;; should make_coroutine be called something like invoke_as_coroutine
;; ? 

(add-test! 'letcc 'invoke-coroutine
  ;; this should behave just like the preceding one:
  ;;  > (run co1)
  ;; 100
  ;; 5
  ;; 200
  ;; -5
  ;; 101
  ;; 4
  ;; 201
  ;; -6
  ;; and then return 202
"let invoke_coroutine = proc (arg, loc, body)
                      if context?(deref(loc))
                      then throw(deref(loc), arg)
                      else let yield = proc (q, n) letcc k1 
                                                    in begin 
                                                         setref(loc, k1);
                                                         (q n)
                                                       end
                           in (body yield arg)
     p1k = newref(0)
     p2k = newref(0)
in letrec
     p1 (n) = (invoke_coroutine n p1k
                proc(yield,n) 
                    begin
                     print(100);
                     print(n);
                     (yield p2 -(0,n));
                     print(101);
                     print(sub1(n));
                     (yield p2 1000)
                    end         
                )
     p2 (n) = (invoke_coroutine n p2k
                proc(yield,n)
                      begin
                       print(200);
                       print(n);
                       (yield p1 2000);
                       print(201);
                       print(sub1(n));
                       (yield p1 202);
                       setref(999999,0)   % never executed
                      end
               )
  in (p1 5)"
202)
; (run-all)
