(let ((time-stamp "Time-stamp: <2004-02-27 11:00:53 Owner>"))
  (eopl:printf "cps1-registers.scm: ~a~%"
    (substring time-stamp 13 29)))

;;; test with (run-all)

;; annoying thing for PLT

(load "test-harness.scm")
(load "test-suite.scm")

;;;;;;;;;;;;;;;; syntax ;;;;;;;;;;;;;;;;

(define the-lexical-spec
  '((whitespace (whitespace) skip)
    (comment ("%" (arbno (not #\newline))) skip)
    (identifier
      (letter (arbno (or letter digit "_" "-" "?")))
      make-symbol)
    (number (digit (arbno digit)) make-number)
    (number ("-" digit (arbno digit)) make-number)
    ))

(define the-grammar
  '((program (expression) a-program)

    ;; arithmetic ops
    (expression (number) lit-exp)
    (expression ("-" "(" expression "," expression ")") diff-exp)
    
    ;; 1-argument procedures
    (expression (identifier) var-exp) 
    (expression
      ("proc" identifier expression)
      proc-exp)
    (expression
      ("(" expression expression ")")
      app-exp)

    ))

;;;;;;;;;;;;;;;; local tests ;;;;;;;;;;;;;;;;

(add-test! 'cps1 'positive-const "11" 11)

(add-test! 'cps1 'negative-const "-33" -33)

(add-test! 'cps1 'simple-arith-1 "-(44,33)" 11)

(add-test! 'cps1 'nested-arith-left "-(-(44,33),22)" -11)

(add-test! 'cps1 'nested-arith-right "-(55, -(22,11))" 44)

(add-test! 'cps1 'simple-app "(proc x x  11)" 11)

(add-test! 'cps1 'simple-curried-app "((proc x proc y -(x,y) 5) 6)" -1)

(add-test! 'cps1 'pass-a-procedure "(proc f (f 11) proc x x)" 11)

(add-test! 'cps1 'check-shadowing "(proc f (f 11) proc f f)" 11)

(add-test! 'cps1 'twice "
 (proc twice
   ((twice proc z -(z,1)) 11)
 proc f proc x (f (f x)))" 9)

;;;;;;;;;;;;;;;; sllgen boilerplate ;;;;;;;;;;;;;;;;

(sllgen:make-define-datatypes the-lexical-spec the-grammar)

(define show-the-datatypes
  (lambda () (sllgen:list-define-datatypes the-lexical-spec the-grammar)))

(define scan&parse
  (sllgen:make-string-parser the-lexical-spec the-grammar))

(define just-scan
  (sllgen:make-string-scanner the-lexical-spec the-grammar))

;;;;;;;;;;;;;;;; interface to test harness ;;;;;;;;;;;;;;;;

(define run
  (lambda (string)
    (eval-program (scan&parse string))))

(define run-all
  (lambda ()
    (run-experiment run use-execution-outcome
      '(cps1) all-tests equal?)))

(define run-one
  (lambda (test-name)
    (run-test run test-name)))

;;;;;;;;;;;;;;;; expressed values ;;;;;;;;;;;;;;;;

(define expval?
  (lambda (v)
    (or (number? v) (procval? v))))

(define-datatype procval procval?
  (closure
    (id symbol?)
    (body expression?)
    (env environment?)))

;;;;;;;;;;;;;;;; contexts ;;;;;;;;;;;;;;;;

(define-datatype context context?
  (empty-context)                       ; []
  (diff1-context                        ; cxt[(- [] (eval-exp e2 env))]
    (e2 expression?)
    (env environment?)
    (cxt context?))
  (diff2-context                        ; cxt[(- val1 [])]
    (val1 expval?)
    (cxt context?))
  (app1-context            ; cxt[(apply-procval [] (eval-exp e2 env))]
    (e2 expression?)
    (env environment?)
    (cxt context?))
  (app2-context                         ; cxt[(apply-procval val [])]
    (val expval?)
    (cxt context?))
  )
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;; the interpreter proper ;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; have the interpreter procedures communicate via registers

(define exp 'uninitialized)
(define env 'uninitialized)
(define cxt 'uninitialized)
(define val 'uninitialized)

(define eval-program
  (lambda (pgm)
    (cases program pgm
      (a-program (the-exp)
        (set! exp the-exp)
        (set! env (empty-env))
        (set! cxt (empty-context))
        (eval-exp-c)))))

(define eval-exp-c                      ; == cxt[(eval-exp exp)]
  (lambda ()
    (cases expression exp
      (lit-exp (n)
        (set! val n)
        ;; cxt is unchanged
        (apply-context))
      (diff-exp (e1 e2)
        (set! cxt (diff1-context e2 env cxt))
        ;; env is unchanged
        (set! exp e1)
        (eval-exp-c))
      (var-exp (id)
        (set! val (apply-env env id))
        (apply-context))
      (proc-exp (id exp)
        (set! val (closure id exp env))
        (apply-context))
      (app-exp (e1 e2)
        (set! exp e1)
        (set! cxt (app1-context e2 env cxt))
        (eval-exp-c))
      )))

(define apply-context                   ; == cxt[val]
  (lambda ()
    (cases context cxt
      (empty-context () val)
      (diff1-context (e2 saved-env saved-cxt) ; can't call these "env"
                                        ; or "cxt" 
        (set! exp e2)
        (set! env saved-env)
        (set! cxt (diff2-context val saved-cxt))
        (eval-exp-c))
      (diff2-context (m saved-cxt)
        (if (and (number? m) (number? val))
          (begin
            (set! cxt saved-cxt)
            (set! val (- m val))
            (apply-context))
          (eopl:error 'apply-context
            "non-number to - arg1 = ~s arg2 = ~s"
            m val)))
      (app1-context (e2 saved-env saved-cxt)
        (set! exp e2)
        (set! env saved-env)
        (set! cxt (app2-context val saved-cxt))
        (eval-exp-c))
      (app2-context (val1 saved-cxt)
        (if (procval? val1)
          (cases procval val1
            (closure (id body saved-env)
              (set! exp body)
              (set! env (extend-env id val saved-env))
              (set! cxt saved-cxt)
              (eval-exp-c)))
          (eopl:error 'apply-context
            "attempt to apply non procval ~s"
            val1)))) ))

;;;;;;;;;;;;;;;; environments ;;;;;;;;;;;;;;;;

;; keeping it simple...

(define-datatype environment environment?
  (empty-env)
  (extend-env
    (id symbol?)
    (val expval?)
    (old-env environment?)))

(define apply-env
  (lambda (env sym)
    (cases environment env
      (empty-env ()
        (eopl:error 'apply-env "unbound variable ~s" sym))
      (extend-env (var val old-env)
        (if (eqv? sym var)
          val
          (apply-env old-env sym))))))
