(let ((time-stamp "Time-stamp: <2004-02-27 11:10:37 Owner>"))
  (eopl:printf "cps1.scm: ~a~%"
    (substring time-stamp 13 29)))

;;; test with (run-all)

;;;;;;;;;;;;;;;; syntax ;;;;;;;;;;;;;;;;

(define the-lexical-spec
  '((whitespace (whitespace) skip)
    (comment ("%" (arbno (not #\newline))) skip)
    (identifier
      (letter (arbno (or letter digit "_" "-" "?")))
      make-symbol)
    (number (digit (arbno digit)) make-number)
    (number ("-" digit (arbno digit)) make-number)
    ))

(define the-grammar
  '((program (expression) a-program)

    ;; arithmetic ops
    (expression (number) lit-exp)
    (expression ("-" "(" expression "," expression ")") diff-exp)
    
    ;; 1-argument procedures
    (expression (identifier) var-exp) 
    (expression
      ("proc" identifier expression)
      proc-exp)
    (expression
      ("(" expression expression ")")
      app-exp)

    ))

;;;;;;;;;;;;;;;; local tests ;;;;;;;;;;;;;;;;

(add-test! 'cps1 'positive-const "11" 11)

(add-test! 'cps1 'negative-const "-33" -33)

(add-test! 'cps1 'simple-arith-1 "-(44,33)" 11)

(add-test! 'cps1 'nested-arith-left "-(-(44,33),22)" -11)

(add-test! 'cps1 'nested-arith-right "-(55, -(22,11))" 44)

(add-test! 'cps1 'simple-app "(proc x x  11)" 11)

(add-test! 'cps1 'simple-curried-app "((proc x proc y -(x,y) 5) 6)" -1)

(add-test! 'cps1 'pass-a-procedure "(proc f (f 11) proc x x)" 11)

(add-test! 'cps1 'check-shadowing "(proc f (f 11) proc f f)" 11)

(add-test! 'cps1 'twice "
 (proc twice
   ((twice proc z -(z,1)) 11)
 proc f proc x (f (f x)))" 9)

;;;;;;;;;;;;;;;; sllgen boilerplate ;;;;;;;;;;;;;;;;

(sllgen:make-define-datatypes the-lexical-spec the-grammar)

(define show-the-datatypes
  (lambda () (sllgen:list-define-datatypes the-lexical-spec the-grammar)))

(define scan&parse
  (sllgen:make-string-parser the-lexical-spec the-grammar))

(define just-scan
  (sllgen:make-string-scanner the-lexical-spec the-grammar))

;;;;;;;;;;;;;;;; interface to test harness ;;;;;;;;;;;;;;;;

(define run
  (lambda (string)
    (eval-program (scan&parse string))))

(define eval-program
  (lambda (pgm)
    (cases program pgm
      (a-program (exp)
        (eval-exp-c
          exp
          (empty-env)
          (empty-context))))))

(define run-all
  (lambda ()
    (run-experiment run use-execution-outcome
      '(cps1) all-tests equal?)))

(define run-one
  (lambda (test-name)
    (run-test run test-name)))

;;;;;;;;;;;;;;;; expressed values ;;;;;;;;;;;;;;;;

(define expval?
  (lambda (v)
    (or (number? v) (procval? v))))

(define-datatype procval procval?
  (closure
    (id symbol?)
    (body expression?)
    (env environment?)))

;;;;;;;;;;;;;;;; contexts ;;;;;;;;;;;;;;;;

(define-datatype context context?
  (empty-context)                       ; []
  (diff1-context                        ; cxt[(- [] (eval-exp e2 env))]
    (e2 expression?)
    (env environment?)
    (cxt context?))
  (diff2-context                        ; cxt[(- val1 [])]
    (val1 expval?)
    (cxt context?))
  (app1-context            ; cxt[(apply-procval [] (eval-exp e2 env))]
    (e2 expression?)
    (env environment?)
    (cxt context?))
  (app2-context                         ; cxt[(apply-procval val [])]
    (val expval?)
    (cxt context?))
  )
  
(define eval-exp-c                      ; == cxt[(eval-exp exp)]
  (lambda (exp env cxt)
    (cases expression exp
      (lit-exp (n) (apply-context cxt n))
      (diff-exp (e1 e2)
        (eval-exp-c e1 env
          (diff1-context e2 env cxt)))
      (var-exp (id) (apply-context cxt (apply-env env id)))
      (proc-exp (id exp)
        (apply-context cxt (closure id exp env)))
      (app-exp (e1 e2)
        (eval-exp-c e1 env (app1-context e2 env cxt)))
      )))

(define apply-context                   ; == cxt[val]
  (lambda (cxt val)
    (cases context cxt
      (empty-context () val)
      (diff1-context (e2 env cxt)
        (eval-exp-c e2 env (diff2-context val cxt)))
      (diff2-context (m cxt)
        (if (and (number? m) (number? val))
          (apply-context cxt (- m val))
          (eopl:error 'apply-context
            "non-number to - arg1 = ~s arg2 = ~s"
            m val)))
      (app1-context (e2 env cxt)
        (eval-exp-c e2 env (app2-context val cxt)))
      (app2-context (val1 cxt)
        (if (procval? val1)
          (cases procval val1
            (closure (id exp saved-env)
              (eval-exp-c exp (extend-env id val saved-env) cxt)))
          (eopl:error 'apply-context
            "attempt to apply non procval ~s"
            val1)))) ))

        
;;;;;;;;;;;;;;;; environments ;;;;;;;;;;;;;;;;

;; keeping it simple...

(define-datatype environment environment?
  (empty-env)
  (extend-env
    (id symbol?)
    (val expval?)
    (old-env environment?)))

(define apply-env
  (lambda (env sym)
    (cases environment env
      (empty-env ()
        (eopl:error 'apply-env "unbound variable ~s" sym))
      (extend-env (var val old-env)
        (if (eqv? sym var)
          val
          (apply-env old-env sym))))))
