(let ((time-stamp "Time-stamp: <2004-02-10 16:40:22 wand>"))
  (eopl:printf "cps0.scm: ~a~%"
    (substring time-stamp 13 29)))

;;; cps0.scm: continuation-passing interpreter for arithmetic
;;; expressions 

(define-datatype expression expression?
  (lit-exp
    (literal number?))
  (diff-exp
    (arg1 expression?)
    (arg2 expression?)))
  

(define-datatype context context?
  (empty-context)                       ; []
  (diff1-context                        ; cxt[(- [] (eval-exp e2))]
    (e2 expression?)
    (cxt context?))
  (diff2-context                        ; cxt[(- val1 [])]
    (val1 number?)
    (cxt context?)))

(define eval-exp-c                      ; = cxt[(eval-exp exp)]
  (lambda (exp cxt)
    (cases expression exp
      (lit-exp (n) (apply-context cxt n))
      (diff-exp (e1 e2)
        (eval-exp-c e1
          (diff1-context e2 cxt)))
      )))

(define apply-context                   ; = cxt[n]
  (lambda (cxt n)
    (cases context cxt
      (empty-context () n)
      (diff1-context (e2 cxt)
        (eval-exp-c e2 (diff2-context n cxt)))
      (diff2-context (m cxt)
        (apply-context cxt (- m n))))))
