package lawOfDemeter;
import java.util.*;

// the only aspect we need for this simplified version
public aspect Checker extends Supplier
    perthis(Any.ConstructorExecution()){
  before(): // direct parts
    Any.Set() {
      // There is only one argument to a set join point.
      // Becomes a preferred supplier and is therefore added to targets.
      addAll(thisJoinPoint.getArgs(), direct+at(thisJoinPoint));
      System.out.println("Adding--" + thisJoinPoint + at(thisJoinPoint));
  }
  before(): // check
    // we check method calls because 1. we need the this and target object
    // 2. we can check more.
    // http://aspectj.org/doc/dist/faq.html#q:comparecallandexecution
    // the meaning of the signature in the execution() and call()
    // pointcut designators (PCD's) differ:
    // the call type depends upon the type of the reference making the call,
    // while the execution type depends on the enclosing class.
    Any.MethodCall() {
      // we don't need the currently executing object.
      // Object this = thisJoinPoint.getThis();
      Object target = thisJoinPoint.getTarget();

      System.out.print("Checking--" + thisJoinPoint + at(thisJoinPoint));
      // for debugging
//      printHashMap(targets);
      // if the target is not a preferred supplier -> Violation
      if (!contains(target))
        System.out.println(" !! LoD Violation !! ");
  }
}
