// sol/part-fix-per-this
package lawOfDemeter;
import java.util.*;

/**
 * An implementation of a part of the LoD checker. Only allows calls to
 * immediate part objects (data members of this).
 * Will create many violations for this simplified form.
 *
 * @author David H. Lorenz (author of correct version)
 */
abstract class Any {
  // we encapsulate all pointcuts we need in a class and
  // refer to them later as Any.*

  // to avoid capturing join points in the advice
  // of the LoD checker itself. within(someClass)
  // picks out all join points where the executing code is defined in someClass.
  // ! is complement.
  private pointcut scope(): !within(lawOfDemeter..*) ; // not in this package
  // AspectJ doc: http://aspectj.org/doc/dist/progguide/apas02.html
  // .. in an identifier any sequence of characters starting and ending with "."
  // * is the wildcard symbol. l..* matches e.g. l.p1.p2.C and also l.C

  // capturing method calls.
  // thisJoinPoint.getThis() and thisJoinPoint.getTarget() denote usually two
  // distinct objects: the currently executing object and the target object.
  pointcut MethodCall(): scope() && call(* *(..));
  // identical: pointcut MethodExecution(): scope() && execution(* *.*(..));
  // The defining type name, if not present, defaults to *
  // AspectJ doc: http://aspectj.org/doc/dist/progguide/apbs02.html

  // capturing method executions.
  // thisJoinPoint.getThis() and thisJoinPoint.getTarget() denote identical
  // objects: the target object.
  // pointcut call(Signature)
  // Picks out a method or constructor call join point
  // based on the static signature at the caller side.

  // pointcut execution(Signature)
  // Picks out a method or constructor execution join point
  // based on the static signature at the callee side.


  pointcut MethodExecution(): scope() && execution(* *(..));

  // capturing assignments to data members
  // All set join points are treated as having one argument,
  // the value the field is being set to.
  // example of set pointcut: set(int T.x)
  pointcut Set(): scope() && set(* *.*) ;

  // execution(*.new (..)) is NOT a subset of execution(* *(..)) ??
  pointcut ConstructorExecution(): scope() && (execution(*.new (..)) || initialization(*.new(..)));

  pointcut Execution(): ConstructorExecution() || MethodExecution();

}
