package lodchecker;

import org.aspectj.lang.*;
import org.aspectj.lang.reflect.SourceLocation;
import java.util.*;

aspect LoDPointCuts {
     // count the nesting level of the method executions
     // not the calls!
     int nestingLevel = 0;
     Stack callStack = new Stack();

     // consider all method executions
     pointcut Execution():
       execution(* *(..)) &&
       !within(LoDPointCuts) &&
       !within(JPUtil) &&
       !cflow(call (* JPUtil.*(..)));

     // consider all method calls
     pointcut Call():
       call(* *(..)) &&
       !within(LoDPointCuts) &&
       !within(JPUtil) &&
       !cflow(call (* JPUtil.*(..)));

     // capture all println statements in this aspect and the JPUtil class
     pointcut NestedPrints():
        call(void println(String)) &&
        (within(LoDPointCuts) || within(JPUtil));

     // print a number of tab characters = (nestingLevel - 1) before each println
     // statement in this aspect and the JPUtil class.  Do this to help visualize
     // the nesting of calls
     before():
       NestedPrints() {
        for(int i = 1; i < nestingLevel; i++){
          System.out.print("\t");
        }
       }

     // maintain the stack of join points
     Object around():
       Execution() {
         if (!(thisJoinPoint.getThis() == thisJoinPoint.getTarget())) // an assertion
           System.out.println(" ============ should never happen ");

	 nestingLevel++;                // NOTE: nesting level == callStack.size
         callStack.push(thisJoinPoint);

         // print the call stack at this point of execution
         System.out.println("Call Stack (nested level = " + nestingLevel + "):");
         System.out.println("- top args -");
         JPUtil.toString((JoinPoint)callStack.peek());
         System.out.println("---------");
         for(int i = callStack.size() - 1; i >= 0; i--){
            System.out.println(((JoinPoint)callStack.elementAt(i)).getSignature().toString());
         }
         System.out.println("---------");

         Object p = proceed();

         callStack.pop();
	 nestingLevel--;

	 return p;
     }

     // report the positive situations
     after():
       Call() {
	 Object thisObject = thisJoinPoint.getThis();
	 Object targetObject = thisJoinPoint.getTarget();
         if (thisObject == targetObject) { // print message: "local call"
           System.out.println(" *** OK, local call");
         }
         if (thisObject == null) {
           System.out.println(JPUtil.toString(thisJoinPoint));
           System.out.println(" *** call in static method");
         }
         if (targetObject == null) {
           System.out.println(JPUtil.toString(thisJoinPoint));
           System.out.println(" *** call to static method");
         }
     }
}
