/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.typecheck.classes;

import edu.neu.ccs.demeterf.typecheck.classes.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int j = 0; j < this.expectedTokenSequences.length; ++j) {
            if (n2 < this.expectedTokenSequences[j].length) {
                n2 = this.expectedTokenSequences[j].length;
            }
            for (int k = 0; k < this.expectedTokenSequences[j].length; ++k) {
                stringBuffer.append(this.tokenImage[this.expectedTokenSequences[j][k]]).append(' ');
            }
            if (this.expectedTokenSequences[j][this.expectedTokenSequences[j].length - 1] != 0) {
                stringBuffer.append("...");
            }
            stringBuffer.append(this.eol).append("    ");
        }
        String string = "Encountered \"";
        Token token = this.currentToken.next;
        for (int j = 0; j < n2; ++j) {
            if (j != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + this.add_escapes(token.image);
            token = token.next;
        }
        string = string + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        string = string + "." + this.eol;
        string = this.expectedTokenSequences.length == 1 ? string + "Was expecting:" + this.eol + "    " : string + "Was expecting one of:" + this.eol + "    ";
        string = string + stringBuffer.toString();
        return string;
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int j = 0; j < string.length(); ++j) {
            switch (string.charAt(j)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(j);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

