/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.dispatch.indirect;

import edu.neu.ccs.demeterf.dispatch.indirect.ClassType;
import edu.neu.ccs.demeterf.dispatch.indirect.NamedStar;
import edu.neu.ccs.demeterf.dispatch.indirect.ParamType;
import edu.neu.ccs.demeterf.dispatch.indirect.StarType;
import edu.neu.ccs.demeterf.dispatch.indirect.TypeSearchException;
import edu.neu.ccs.demeterf.util.Util;
import java.lang.reflect.ParameterizedType;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Type {
    static ClsP[] baseTypes = new ClsP[]{new ClsP("short", Short.TYPE), new ClsP("int", Integer.TYPE), new ClsP("long", Long.TYPE), new ClsP("float", Float.TYPE), new ClsP("double", Double.TYPE), new ClsP("char", Character.TYPE), new ClsP("byte", Byte.TYPE), new ClsP("boolean", Boolean.TYPE)};
    static Stack<String> searchPath = new Stack();

    public static Type forClass(Class<?> clazz) {
        return new ClassType(Util.unbox(clazz));
    }

    public static Type forGeneric(ParameterizedType parameterizedType) {
        return new ParamType(parameterizedType);
    }

    public static Type forType(java.lang.reflect.Type type2) {
        if (type2 instanceof ParameterizedType) {
            return Type.forGeneric((ParameterizedType)type2);
        }
        return Type.forClass((Class)type2);
    }

    public static Type star() {
        return new StarType();
    }

    public static Type star(String string) {
        return new NamedStar(string);
    }

    public static Type[] fromClassArray(Class<?>[] classArray) {
        Type[] typeArray = new Type[classArray.length];
        for (int j = 0; j < classArray.length; ++j) {
            Class<?> clazz = classArray[j];
            typeArray[j] = clazz == null && Util.allowNull ? Type.star() : Type.forClass(Util.unbox(clazz));
        }
        return typeArray;
    }

    public static Type[] fromTypeArray(java.lang.reflect.Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int j = 0; j < typeArray.length; ++j) {
            typeArray2[j] = Type.forType(typeArray[j]);
        }
        return typeArray2;
    }

    public static Class<?> classForName(String string) {
        return Type.searchForClass(string);
    }

    public static Type forName(String string) {
        return Type.forClass(Util.unbox(Type.classForName(string)));
    }

    public static void addPath(String string) {
        if (string.length() > 0 && string.charAt(string.length() - 1) != '.') {
            string = string + ".";
        }
        searchPath.insertElementAt(string, 0);
        edu.neu.ccs.demeterf.dispatch.Type.addPath(string);
    }

    public static Class<?> searchForClass(String string) {
        if (Character.isLowerCase(string.charAt(0))) {
            for (int j = 0; j < baseTypes.length; ++j) {
                if (!Type.baseTypes[j].s.equals(string)) continue;
                return Type.baseTypes[j].c;
            }
        }
        for (String object : searchPath) {
            try {
                return Class.forName(object + string);
            }
            catch (ClassNotFoundException string2) {
            }
        }
        Object object = "";
        for (String string2 : searchPath) {
            if (string2.length() <= 0) continue;
            object = (String)object + "     " + string2 + "*\n";
        }
        throw new TypeSearchException(" ** Class Not Found: " + string + "\n  Search Paths:\n" + (String)object);
    }

    public abstract boolean isAssignableFrom(Type var1);

    public abstract boolean isAssignableFrom(Class<?> var1);

    public abstract Type getSuperClass();

    public abstract boolean equals(Object var1);

    public abstract String getSimpleName();

    public boolean isClass() {
        return false;
    }

    public boolean isStar() {
        return false;
    }

    public abstract Class<?> getType();

    public java.lang.reflect.Type getGenType() {
        return this.getType();
    }

    public abstract Type boxedType();

    public abstract Type unboxedType();

    public String toString() {
        return this.getSimpleName();
    }

    static {
        Type.addPath("java.lang.");
        Type.addPath("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClsP {
        String s;
        Class<?> c;

        ClsP(String string, Class<?> clazz) {
            this.s = string;
            this.c = clazz;
        }
    }
}

