/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.Output;
import admin.ProcessWatcher;
import admin.StreamWatcher;
import admin.Util;
import admin.utils.AccountUpdater;
import admin.utils.AdminDocumentHandler;
import admin.utils.Game;
import admin.utils.RuleChecker;
import admin.utils.StoreUpdater;
import config.AdminConfig;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Config;
import gen.Deliver;
import gen.Derivative;
import gen.Finish;
import gen.Pair;
import gen.Player;
import gen.PlayerID;
import gen.PlayerStore;
import gen.PlayerTransaction;
import gen.Players;
import gen.Round;
import gen.Store;
import gen.Transaction;
import java.io.File;
import java.io.IOException;

public class Administrator {
    private Players players = AdminDocumentHandler.getPlayers();
    private Config config = AdminDocumentHandler.getConfig();
    private File playerDir = new File("blackboard" + AdminConfig.PLAYERS_PATH);
    private Store store = AdminDocumentHandler.getStore();
    private Accounts accounts = AdminDocumentHandler.getAccounts();
    Output out;
    static List<String> gameTypes = List.create("-tball", "-slowpitch", "-fastpitch", "-baseball");
    long curTurnFin = System.currentTimeMillis();
    static Runtime runtime = Runtime.getRuntime();

    Administrator(Output output) {
        this.out = output;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 2 || stringArray.length < 1 || Game.gameType(stringArray[0]) == Game.GameType.NONE) {
            System.err.println(" ** Usage: java -jar admin.jar <GameType> [OutputFile]\n   - GameType is one of -tball, -slowpitch, -fastpitch, -baseball\n   - Run the administrator under the specified rule set\n   - Run the administrator with output to the given file (optional).\n   - If no file is given, StdErr is used.");
            System.exit(1);
        }
        Output output = stringArray.length == 2 ? Output.htmlOutput(stringArray[1]) : Output.htmlOutput();
        AdminDocumentHandler.resetFilesToDefault();
        new Administrator(output).main(Game.gameType(stringArray[0]));
    }

    private void main(final Game.GameType gameType) {
        int n;
        long l = this.curTurnFin;
        this.out.header();
        for (n = 0; n < this.config.Rounds && this.players.length() > 1; ++n) {
            this.out.newRound(n + 1, this.config.Rounds);
            System.err.println(" * Starting Round #" + (n + 1) + " of " + this.config.Rounds);
            Round round = new Round(n, this.players.players.map(new List.Map<Player, PlayerTransaction>(){

                @Override
                public PlayerTransaction map(Player player2) {
                    Administrator.this.out.time("Admin overhead", Administrator.this.curTurnFin);
                    Administrator.this.out.line("");
                    if (Administrator.this.passTurn(player2)) {
                        Administrator.this.curTurnFin = System.currentTimeMillis();
                        PlayerTransaction playerTransaction = AdminDocumentHandler.getPlayerTrans(player2);
                        if (playerTransaction != null) {
                            Pair<Boolean, String> pair = RuleChecker.rulesFollowed(playerTransaction, Administrator.this.store, Administrator.this.accounts, gameType);
                            if (((Boolean)pair.a).booleanValue()) {
                                playerTransaction = Util.computeQualities(playerTransaction);
                                long l = System.currentTimeMillis();
                                Administrator.this.updateStore(playerTransaction);
                                l = System.currentTimeMillis();
                                Administrator.this.updateAccounts(playerTransaction);
                                return playerTransaction;
                            }
                            Administrator.this.out.violation((String)pair.b, player2);
                        } else {
                            Administrator.this.out.violation("No Transaction", player2);
                        }
                    } else {
                        Administrator.this.out.violation("Time Violation or missing jar", player2);
                    }
                    Administrator.this.takeViolationAction(Administrator.this.players, player2);
                    Administrator.this.players = Administrator.this.players.remove(player2.id);
                    return new PlayerTransaction(player2, List.create(new Transaction[0]));
                }
            }));
            long l2 = System.currentTimeMillis();
            AdminDocumentHandler.updateHistory(round);
        }
        for (int i = 1; i <= 2; ++i) {
            this.out.newOTRound(i);
            System.err.println(" * Starting Overtime Round #" + i + " of 2.");
            Round round = new Round(n, this.players.players.map(new List.Map<Player, PlayerTransaction>(){

                @Override
                public PlayerTransaction map(Player player2) {
                    Administrator.this.out.time("Admin overhead", Administrator.this.curTurnFin);
                    Administrator.this.out.line("");
                    if (Administrator.this.passTurn(player2)) {
                        Administrator.this.curTurnFin = System.currentTimeMillis();
                        PlayerTransaction playerTransaction = AdminDocumentHandler.getPlayerTrans(player2);
                        if (playerTransaction != null) {
                            List<Transaction> list = playerTransaction.transactions.filter(new List.Pred<Transaction>(){

                                @Override
                                public boolean huh(Transaction transaction) {
                                    return transaction.ttype instanceof Deliver || transaction.ttype instanceof Finish;
                                }
                            });
                            playerTransaction = new PlayerTransaction(playerTransaction.player, list);
                            Pair<Boolean, String> pair = RuleChecker.overtimeRulesFollowed(playerTransaction, Administrator.this.store, Administrator.this.accounts, gameType);
                            if (((Boolean)pair.a).booleanValue()) {
                                playerTransaction = Util.computeQualities(playerTransaction);
                                long l = System.currentTimeMillis();
                                Administrator.this.updateStore(playerTransaction);
                                l = System.currentTimeMillis();
                                Administrator.this.updateAccounts(playerTransaction);
                                return playerTransaction;
                            }
                            Administrator.this.out.violation((String)pair.b, player2);
                        } else {
                            Administrator.this.out.violation("No Transaction", player2);
                        }
                    } else {
                        Administrator.this.out.violation("Time Violation or missing jar", player2);
                    }
                    Administrator.this.takeViolationAction(Administrator.this.players, player2);
                    Administrator.this.players = Administrator.this.players.remove(player2.id);
                    return new PlayerTransaction(player2, List.create(new Transaction[0]));
                }
            }));
            long l3 = System.currentTimeMillis();
            AdminDocumentHandler.updateHistory(round);
        }
        this.out.time("Admin overhead", this.curTurnFin);
        this.out.time("Total Game time", l);
        this.declareWinner();
        this.out.footer();
    }

    private void declareWinner() {
        this.out.finishTable(this.accounts, this.players, AdminDocumentHandler.getPlayers());
    }

    private void takeViolationAction(Players players2, Player player2) {
        if (this.store.contains(player2.id)) {
            for (Derivative object : this.store.getStore((Player)player2).bought) {
                this.accounts = this.accounts.update(Util.pair(object.seller, -object.price.val));
                this.store = this.store.replace(Util.spair(object.seller, this.store.getStore(object.seller).pushSale(new Derivative(object.name, object.seller, object.price, object.type))));
            }
            for (Player player3 : players2.players) {
                Pair<PlayerID, PlayerStore> pair = this.store.getStorePair(player3.id);
                List<Derivative> list = ((PlayerStore)pair.b).bought;
                for (Derivative derivative : list) {
                    if (!derivative.seller.equals(player2.id)) continue;
                    this.accounts = this.accounts.update(Util.pair((PlayerID)pair.a, derivative.price.val));
                    list = list.remove(derivative);
                }
                ((PlayerStore)pair.b).bought = list;
                this.store = this.store.replace(pair);
            }
        }
        AdminDocumentHandler.commitStore(this.store.remove(player2.id));
        AdminDocumentHandler.commitAccounts(this.accounts.remove(player2.id));
    }

    private void updateStore(PlayerTransaction playerTransaction) {
        this.store = StoreUpdater.updateStore(this.store, playerTransaction);
        AdminDocumentHandler.commitStore(this.store);
    }

    private void updateAccounts(PlayerTransaction playerTransaction) {
        this.accounts = AccountUpdater.updateAccounts(this.accounts, playerTransaction);
        AdminDocumentHandler.commitAccounts(this.accounts);
    }

    private boolean passTurn(Player player2) {
        this.out.println("");
        this.out.line("** Player " + player2.id.id + ": Team " + player2.name + "'s turn");
        String string = "blackboard" + AdminConfig.PLAYERS_PATH + "/" + player2.name;
        String string2 = "java -Xss1M -jar " + player2.name + ".jar " + player2.id.id + " " + player2.name;
        String string3 = string + ".exe " + player2.id.id + " " + player2.name;
        String string4 = string2;
        if (!new File(string + ".jar").exists()) {
            if (!new File(string + ".exe").exists()) {
                return false;
            }
            string4 = string3;
        }
        long l = 0L;
        long l2 = 0L;
        try {
            l = System.currentTimeMillis();
            this.out.playerStart();
            Process process = runtime.exec(string4, null, this.playerDir);
            StreamWatcher streamWatcher = new StreamWatcher(process.getInputStream());
            StreamWatcher streamWatcher2 = new StreamWatcher(process.getErrorStream());
            ProcessWatcher processWatcher = new ProcessWatcher(process);
            processWatcher.waitForTimeLimit(this.config.Time);
            l2 = System.currentTimeMillis();
            streamWatcher.done();
            streamWatcher2.done();
            this.out.playerEnd();
            this.out.time("Player " + player2.id.id + ": Team " + player2.name + " finished", l);
            this.out.println(this.out.vspace() + this.out.vspace());
            if (l2 - l > (long)this.config.Time) {
                process.destroy();
                return false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }
}

