/*
 * Decompiled with CFR 0.152.
 */
package admin.utils;

import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.TUCombiner;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Buy;
import gen.Create;
import gen.Deliver;
import gen.Derivative;
import gen.Finish;
import gen.Pair;
import gen.PlayerID;
import gen.PlayerStore;
import gen.PlayerTransaction;
import gen.Reoffer;
import gen.Store;
import gen.Transaction;
import gen.TransactionType;
import utils.ListTUCombiner;
import utils.comparator.DerivativeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreUpdater
extends ListTUCombiner<Pair<PlayerID, PlayerStore>> {
    private PlayerID pID;
    Pair<PlayerID, PlayerStore> playerStore;
    private Store store;
    static List<Derivative> empty = List.create(new Object[0]);

    public StoreUpdater(PlayerID playerID, Store store) {
        this.store = store;
        this.pID = playerID;
    }

    Pair<PlayerID, PlayerStore> getPlayerStore() {
        if (!this.store.contains(this.pID)) {
            this.store = this.store.add(new Pair<PlayerID, PlayerStore>(this.pID, new PlayerStore(empty, empty)));
        }
        return this.store.getStorePair(this.pID);
    }

    public static Store updateStore(Store store, PlayerTransaction playerTransaction) {
        StoreUpdater storeUpdater = new StoreUpdater(playerTransaction.player.id, store);
        TUCombiner.traverse(playerTransaction, storeUpdater, Control.builtins(Derivative.class, TransactionType.class));
        return storeUpdater.store;
    }

    TransactionType combine(TransactionType transactionType) {
        return transactionType;
    }

    List<Pair<PlayerID, PlayerStore>> combine(Transaction transaction, Buy buy) {
        Pair<PlayerID, PlayerStore> pair = this.getPlayerStore();
        ((PlayerStore)pair.b).bought = ((PlayerStore)pair.b).bought.push(transaction.deriv.buy(this.pID));
        Pair<PlayerID, PlayerStore> pair2 = this.store.getStorePair(transaction.deriv.seller);
        ((PlayerStore)pair2.b).forSale = ((PlayerStore)pair2.b).forSale.remove(new DerivativeComparator(transaction.deriv));
        this.store = this.store.replace(pair);
        this.store = this.store.replace(pair2);
        return List.create(pair, pair2);
    }

    List<Pair<PlayerID, PlayerStore>> combine(Transaction transaction, Finish finish) {
        Pair<PlayerID, PlayerStore> pair = this.getPlayerStore();
        ((PlayerStore)pair.b).bought = ((PlayerStore)pair.b).bought.remove(new DerivativeComparator(transaction.deriv));
        this.store = this.store.replace(pair);
        return List.create(pair);
    }

    List<Pair<PlayerID, PlayerStore>> combine(Transaction transaction, Create create) {
        Pair<PlayerID, PlayerStore> pair = this.getPlayerStore();
        ((PlayerStore)pair.b).forSale = ((PlayerStore)pair.b).forSale.push(transaction.deriv);
        this.store = this.store.replace(pair);
        return List.create(pair);
    }

    List<Pair<PlayerID, PlayerStore>> combine(Transaction transaction, Deliver deliver) {
        Pair<PlayerID, PlayerStore> pair = this.store.getStorePair(transaction.deriv.optbuyer.inner());
        ((PlayerStore)pair.b).bought = ((PlayerStore)pair.b).bought.remove(new DerivativeComparator(transaction.deriv));
        ((PlayerStore)pair.b).bought = ((PlayerStore)pair.b).bought.push(transaction.deriv);
        this.store = this.store.replace(pair);
        return List.create(pair);
    }

    List<Pair<PlayerID, PlayerStore>> combine(Transaction transaction, Reoffer reoffer) {
        Pair<PlayerID, PlayerStore> pair = this.getPlayerStore();
        ((PlayerStore)pair.b).forSale = ((PlayerStore)pair.b).forSale.push(transaction.deriv);
        this.store = this.store.replace(pair);
        return List.create(pair);
    }
}

