/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.Relation;
import edu.neu.ccs.evergreen.ir.RelationCore;
import edu.neu.ccs.evergreen.ir.RelationI;
import edu.neu.ccs.evergreen.ir.RelationNumberUtil;

public class RelationFactory {
    public static RelationI or(int rank, int ... variablePositions) {
        return new Relation(rank, RelationNumberUtil.or(rank, variablePositions));
    }

    public static RelationI and(int rank, int ... variablePositions) {
        return new Relation(rank, RelationNumberUtil.and(rank, variablePositions));
    }

    public static RelationI nMap(int relationNumber, int rank, int ... variablePositions) {
        return new Relation(rank, RelationNumberUtil.nMap(relationNumber, rank, variablePositions));
    }

    public static RelationI nMap(RelationI relation, int ... variablePositions) {
        return new Relation(relation.getRank(), RelationNumberUtil.nMap(relation.getRelationNumber(), relation.getRank(), variablePositions));
    }

    public static RelationI imply(int rank, int ... variablePositions) {
        return new Relation(rank, RelationNumberUtil.imply(rank, variablePositions));
    }

    public static RelationI equiv(int rank, int ... variablePositions) {
        return new Relation(rank, RelationNumberUtil.equiv(rank, variablePositions));
    }

    public static RelationI xor(int rank, int ... variablePositions) {
        return new Relation(rank, RelationNumberUtil.xor(rank, variablePositions));
    }

    public static RelationI xTrueVars(int rank, int numberOfTrueVars) {
        return new Relation(rank, RelationNumberUtil.xTrueVars(rank, numberOfTrueVars));
    }

    public static RelationI or(RelationI ... relations) {
        if (relations.length == 0) {
            throw new IllegalArgumentException("or Must have at least one argument");
        }
        int rank = relations[0].getRank();
        int relationNumber = 0;
        RelationI[] relationIArray = relations;
        int n = 0;
        int n2 = relationIArray.length;
        while (n < n2) {
            RelationI relation = relationIArray[n];
            if (relation.getRank() != rank) {
                throw new IllegalArgumentException("All relations must be of the same rank");
            }
            relationNumber |= relation.getRelationNumber();
            ++n;
        }
        return new Relation(rank, relationNumber);
    }

    public static RelationI and(RelationI ... relations) {
        if (relations.length == 0) {
            throw new IllegalArgumentException("and Must have at least one argument");
        }
        int rank = relations[0].getRank();
        int relationNumber = RelationCore.getMask(rank);
        RelationI[] relationIArray = relations;
        int n = 0;
        int n2 = relationIArray.length;
        while (n < n2) {
            RelationI relation = relationIArray[n];
            if (relation.getRank() != rank) {
                throw new IllegalArgumentException("All relations must be of the same rank");
            }
            relationNumber &= relation.getRelationNumber();
            ++n;
        }
        return new Relation(rank, relationNumber);
    }

    public static RelationI not(RelationI relation) {
        if (relation == null) {
            throw new IllegalArgumentException("argument relation cannot be null");
        }
        int r = relation.getRelationNumber();
        int rank = relation.getRank();
        int relationNumber = ~r & RelationCore.getMask(rank);
        return new Relation(rank, relationNumber);
    }

    public static RelationI xor(RelationI relation1, RelationI relation2) {
        if (relation1 == null || relation2 == null) {
            throw new IllegalArgumentException("argument relation cannot be null");
        }
        if (relation1.getRank() != relation2.getRank()) {
            throw new IllegalArgumentException("All relations must be of the same rank");
        }
        int r1 = relation1.getRelationNumber();
        int r2 = relation2.getRelationNumber();
        int rank = relation1.getRank();
        int relationNumber = (r1 ^ r2) & RelationCore.getMask(rank);
        return new Relation(rank, relationNumber);
    }

    public static RelationI equiv(RelationI relation1, RelationI relation2) {
        if (relation1 == null || relation2 == null) {
            throw new IllegalArgumentException("argument relation cannot be null");
        }
        if (relation1.getRank() != relation2.getRank()) {
            throw new IllegalArgumentException("All relations must be of the same rank");
        }
        int r1 = relation1.getRelationNumber();
        int r2 = relation2.getRelationNumber();
        int rank = relation1.getRank();
        int relationNumber = ~(r1 ^ r2) & RelationCore.getMask(rank);
        return new Relation(rank, relationNumber);
    }

    public static RelationI imply(RelationI relation1, RelationI relation2) {
        if (relation1 == null || relation2 == null) {
            throw new IllegalArgumentException("argument relation cannot be null");
        }
        if (relation1.getRank() != relation2.getRank()) {
            throw new IllegalArgumentException("All relations must be of the same rank");
        }
        int r1 = relation1.getRelationNumber();
        int r2 = relation2.getRelationNumber();
        int rank = relation1.getRank();
        int relationNumber = (~r1 | r2) & RelationCore.getMask(rank);
        return new Relation(rank, relationNumber);
    }

    public static void main(String[] args) {
        RelationI r1 = RelationFactory.xTrueVars(3, 1);
        RelationI r2 = RelationFactory.xTrueVars(3, 1);
        RelationI rand = RelationFactory.and(r1, r2);
        RelationI ror = RelationFactory.or(r1, r2);
        RelationI rxor = RelationFactory.xor(r1, r2);
        RelationI requiv = RelationFactory.equiv(r1, r2);
        RelationI rimply = RelationFactory.imply(r1, r2);
        RelationI rnot = RelationFactory.not(r1);
        RelationI rnmap = RelationFactory.nMap(r1, 0, 1, 2);
        RelationI rnmap2 = RelationFactory.nMap(r1.getRelationNumber(), r1.getRank(), 0, 1, 2);
        System.out.println("r1: " + r1);
        System.out.println("r2: " + r2);
        System.out.println("rand: " + rand);
        System.out.println("ror: " + ror);
        System.out.println("rxor: " + rxor);
        System.out.println("requiv: " + requiv);
        System.out.println("rimply: " + rimply);
        System.out.println("rnot: " + rnot);
        System.out.println("rnmap:" + rnmap);
        System.out.println("=============");
        RelationI andr = RelationFactory.and(3, 0, 1, 2);
        RelationI orr = RelationFactory.or(3, 0, 1, 2);
        RelationI implyr = RelationFactory.imply(3, 2, 1);
        RelationI equivr = RelationFactory.equiv(3, 2, 1);
        RelationI xorr = RelationFactory.xor(3, 2, 1);
        System.out.println("andr: " + andr);
        System.out.println("orr: " + orr);
        System.out.println("xorr: " + xorr);
        System.out.println("equivr: " + equivr);
        System.out.println("implyr: " + implyr);
    }
}

