/*
 * Decompiled with CFR 0.152.
 */
package player;

import config.GlobalConfig;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Accounts;
import gen.Config;
import gen.Derivative;
import gen.Player;
import gen.PlayerTransaction;
import gen.RelationNr;
import gen.Store;
import gen.Type;
import gen.TypeInstance;
import java.util.Random;
import java.util.UUID;
import utils.DerivativesFinder;
import utils.DocumentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static Random rand = new Random();

    public static double random() {
        return rand.nextDouble();
    }

    public static int random(int n) {
        return rand.nextInt(n);
    }

    public static boolean coinFlip(double d) {
        return Util.random() < d;
    }

    public static boolean coinFlip() {
        return Util.coinFlip(0.5);
    }

    public static void commitTransaction(PlayerTransaction playerTransaction) {
        String string = playerTransaction.player.name + "_done.input";
        DocumentHandler.write((String)playerTransaction.print(), (String)("../" + GlobalConfig.SEPAR + string));
    }

    public static double getAccount(Player player) {
        return Util.getAccounts().getAccount(player);
    }

    public static List<Derivative> needRawMaterial(Player player) {
        return DerivativesFinder.findDersThatNeedRM((List)Util.getStore().stores, (Player)player);
    }

    public static List<Derivative> toBeFinished(Player player) {
        return DerivativesFinder.findDersThatNeedFinishing((List)Util.getStore().stores, (Player)player);
    }

    public static double getMinPriceDec() {
        return Util.getConfig().MPD;
    }

    public static List<Type> existingTypes() {
        return DerivativesFinder.findExistingDerTypes((List)Util.getStore().stores);
    }

    public static List<Derivative> forSale() {
        return DerivativesFinder.findDerivativesForSale((List)Util.getStore().stores);
    }

    public static List<Derivative> uniquelyTyped(List<Derivative> list) {
        return DerivativesFinder.findUniqueDerivatives(list);
    }

    public static String freshName(Player player) {
        UUID uUID = UUID.randomUUID();
        return player.name + "_" + uUID.toString().replace('-', '_');
    }

    public static Type freshType(List<Type> list) {
        Type type;
        while (list.contains(type = new Type(List.create(new TypeInstance(new RelationNr(Util.random(256))))))) {
        }
        return type;
    }

    private static Accounts getAccounts() {
        return DocumentHandler.getAccounts((String)"../");
    }

    private static Store getStore() {
        return DocumentHandler.getStore((String)"../");
    }

    private static Config getConfig() {
        return DocumentHandler.getConfig((String)"../");
    }
}

