/*
 * Decompiled with CFR 0.152.
 */
package hidden;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.ident;
import gen.Constraint;
import gen.RelationNr;
import gen.Variable;
import gen.Weight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    static List<String> cmds = List.create("encode", "test", "symmetric");
    static String MASTER = "009020548cf0d094";
    static int LEN = 8;
    static String hex = "0123456789abcdef";
    static int VAR = 5;
    static int RANK = 3;

    public static List<Constraint> symmetric(List<RelationNr> list, int n, int n2) {
        final List<List<Variable>> list2 = Tools.combs(n, n2, new List.Build<Variable>(){

            @Override
            public Variable build(int n) {
                return new Variable(new ident("v" + n));
            }
        });
        List<Constraint> list3 = list.fold(new List.Fold<RelationNr, List<Constraint>>(){

            @Override
            public List<Constraint> fold(final RelationNr relationNr, List<Constraint> list) {
                return list2.map(new List.Map<List<Variable>, Constraint>(){

                    @Override
                    public Constraint map(List<Variable> list) {
                        return new Constraint(new Weight(1), relationNr, list);
                    }
                }).append((Constraint)list);
            }
        }, List.create(new Constraint[0]));
        return list3;
    }

    public static <X> List<List<X>> combs(int n, int n2, List.Build<X> build) {
        List[][] listArray = new List[n + 1][n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            for (int j = 0; j <= n; ++j) {
                List<Object> list = i == 0 ? List.create(List.create(new Object[0])) : (j < i ? List.create(new Object[0]) : listArray[j - 1][i].append(listArray[j - 1][i - 1].map(new PushN<X>(build.build(j)))));
                listArray[j][i] = list;
            }
        }
        return listArray[n][n2];
    }

    static void p(String string) {
        System.out.println(string);
    }

    static void usage() {
        Tools.p(" ** usage : java Tools <cmd> <args...>\n   Unfortunately the usage and passcode are secret! ;)");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 2 || !cmds.contains(stringArray[0])) {
            Tools.usage();
        }
        if ((n = cmds.index(stringArray[0])) == 0) {
            Tools.doEncode(stringArray[1]);
            return;
        }
        if (!Tools.encode(stringArray[1]).equals(MASTER)) {
            Tools.usage();
        }
        switch (n) {
            case 1: {
                Tools.doTest();
            }
            case 2: {
                Tools.doSymmetric(stringArray);
            }
        }
    }

    static void doEncode(String string) {
        Tools.p(" Result: \"" + Tools.encode(string) + "\"");
    }

    static String encode(String string) {
        int n;
        byte[] byArray = (string + string).getBytes();
        int[] nArray = new int[LEN];
        for (int i = 0; i < LEN; ++i) {
            for (n = 0; n < byArray.length - LEN; ++n) {
                int n2 = i;
                nArray[n2] = nArray[n2] ^ byArray[(i + n) % byArray.length] << 2;
            }
        }
        String string2 = "";
        for (n = 0; n < LEN; ++n) {
            string2 = string2 + hex.charAt(nArray[n] >> 4 & 0xF) + "" + hex.charAt(nArray[n] & 0xF);
        }
        return string2;
    }

    static void doTest() {
        Tools.p(" * Password Correct!");
    }

    static void doSymmetric(String[] stringArray) {
        int n = stringArray.length < 3 ? VAR : Integer.parseInt(stringArray[2]);
        Tools.p("    private static List<Constraint> symForm(RelationNr rel, Weight wt){");
        Tools.p("        return List.<Constraint>create(\n" + Tools.combs(n, RANK, new List.Build<String>(){

            @Override
            public String build(int n) {
                return "v" + n;
            }
        }).toString(new List.Stringer<List<String>>(){

            @Override
            public String toString(List<String> list, List<List<String>> list2) {
                return "            new Constraint(wt, rel, List.<Variable>create(" + list.toString(new List.Stringer<String>(){

                    @Override
                    public String toString(String string, List<String> list) {
                        return "new Variable(new ident(\"" + string + "\"))" + (list.isEmpty() ? "" : ", ");
                    }
                }) + "))" + (list2.isEmpty() ? "" : ",\n");
            }
        }) + ");\n    }");
    }

    private static List<Constraint> symForm(RelationNr relationNr, Weight weight) {
        return List.create(new Constraint(weight, relationNr, List.create(new Variable(new ident("v3")), new Variable(new ident("v2")), new Variable(new ident("v1")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v4")), new Variable(new ident("v2")), new Variable(new ident("v1")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v4")), new Variable(new ident("v3")), new Variable(new ident("v1")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v4")), new Variable(new ident("v3")), new Variable(new ident("v2")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v5")), new Variable(new ident("v2")), new Variable(new ident("v1")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v5")), new Variable(new ident("v3")), new Variable(new ident("v1")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v5")), new Variable(new ident("v3")), new Variable(new ident("v2")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v5")), new Variable(new ident("v4")), new Variable(new ident("v1")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v5")), new Variable(new ident("v4")), new Variable(new ident("v2")))), new Constraint(weight, relationNr, List.create(new Variable(new ident("v5")), new Variable(new ident("v4")), new Variable(new ident("v3")))));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PushN<X>
    extends List.Map<List<X>, List<X>> {
        X x;

        public PushN(X x) {
            this.x = x;
        }

        @Override
        public List<X> map(List<X> list) {
            return list.push(this.x);
        }
    }
}

