/* **********************************
 *   DocumentHandler.java
 *     DocumentHandler
 ************************************/
package utils;

import gen.*;
import java.io.*;
import config.*;

/** Class for handling file reads and writes 
 *    @author Bryan Chadwick, Alex Dubreuil, Greg Ayer */
public class DocumentHandler{
    /** Reads the history */
    public static History getHistory(String bbPath){
        try{ return History.parse(openIn(bbPath+GlobalConfig.SEPAR+AdminConfig.HISTORY_FILE));
        }catch(Exception e){ errorMessage(e); return null; }
    }

    /** Reads the store */
    public static Store getStore(String bbPath){
        try{ return Store.parse(openIn(bbPath+GlobalConfig.SEPAR+AdminConfig.STORE_FILE));
        }catch(Exception e) { errorMessage(e); return null; }
    }

    /** Reads the config */
    public static Config getConfig(String bbPath){
        try{ return Config.parse(openIn(bbPath+GlobalConfig.SEPAR+GlobalConfig.CONFIG_FILE));
        }catch(Exception e) { errorMessage(e); return null; }
    }

    /** Reads the players */
    public static Players getPlayers(String bbPath){
        try{ return Players.parse(openIn(bbPath+GlobalConfig.SEPAR+GlobalConfig.PLAYERS_FILE));
        }catch(Exception e) { errorMessage(e); return null; }
    }

    /** Reads the accounts of players */
    public static Accounts getAccounts(String bbPath){
        try{ return Accounts.parse(openIn(bbPath+GlobalConfig.SEPAR+AdminConfig.ACCOUNTS_FILE));
        }catch(Exception e) { errorMessage(e); return null; }
    }
    
    /** Reads a player transaction. */
    public static PlayerTransaction getPlayerTrans(Player player, String bbPath){
        try{ return PlayerTransaction.parse(openIn(bbPath+GlobalConfig.SEPAR+player.name+GlobalConfig.DONE_FILE_SUFFIX));
        }catch(Exception e){ errorMessage(e); return null; }
    }
    
    /** Deletes a player transaction. */
    public static void deletePlayerTrans(Player player, String bbPath)
    {
    	try{ new File(bbPath+GlobalConfig.SEPAR+player.name+GlobalConfig.DONE_FILE_SUFFIX).delete();
    	}catch(Exception e){ errorMessage(e); }
    }
        
    /** Write out a given String to a file */
    public static void write(String text, String file){ write(text,file,false); }
    /** Write out a given String to a file, maybe append or replace
     *    the old file */
    public static void write(String text, String file, boolean append){
        try{
            PrintStream out = new PrintStream(new FileOutputStream(file, append));
            out.println(text);
            out.close();
        }catch(IOException e){ errorMessage(e); }
    }
    /** Open a file as an InputStream */
    public static InputStream openIn(String file) throws FileNotFoundException{
        return new FileInputStream(file);
    }
    
    /** Print an Error Message for a given Exception */
    public static void errorMessage(Exception e){
        System.err.println(" ** DocumentHandler Error: "+e.getMessage());
    }
}
