/* **********************************
 *   SufficientAssignment.java
 *     SufficientAssignment
 * **********************************/
package admin.utils;

import edu.neu.ccs.demeterf.TUCombiner;
import gen.*;
import admin.hidden.ComputeQuality;

/** @author Alex Dubreuil */
public class SufficientAssignment extends TUCombiner<Boolean>
{
    public SufficientAssignment(){ }
    
    public Boolean combine() { return true; }
    public Boolean combine(Constraint c) { return (c.r.v == 0) || (c.r.v == 255); }
    public Boolean fold(Boolean a, Boolean b) { return a&&b; }
    
    public static boolean good(RawMaterial rm, Assignment a){
        for(Literal next:a.literals){
            rm = ComputeQuality.reduce(rm, next);
        }
        return SufficientAssignment.traverse(rm, new SufficientAssignment());
    }
}
