/* **********************************
 *   SetQualities.java
 *     SetQualities
 * **********************************/
package admin.utils;

import edu.neu.ccs.demeterf.*;
import edu.neu.ccs.demeterf.demfgen.lib.Option;
import edu.neu.ccs.demeterf.demfgen.lib.Some;
import gen.*;
import admin.hidden.*;

/** 
 * @author Alex Dubreuil */
public class SetQualities extends Bc{
    
    /** TODO: Fix kludge-y singleton stuff. */
    static Traversal setQT = new Traversal(new SetQuality(), Control.builtins(RawMaterialInstance.class));
    
    public Transaction combine(Transaction trans, TransactionType ttype, Derivative deriv){
        if(ttype.getClass().equals(Finish.class))
            return new Transaction(ttype, setQT.<Derivative>traverse(deriv));
        return trans;
    }
    public static PlayerTransaction setQs(PlayerTransaction pTrans, Control c){
        return new Traversal(new SetQualities(), c).<PlayerTransaction>traverse(pTrans);
    }
}

class SetQuality extends Bc{
    public Derivative combine(Derivative d) { return d; }
    public Derivative combine(Derivative d,
            String name,
            PlayerID seller,
            Option<PlayerID> buyer,
            Price price,
            Type type,
            Some<RawMaterial> rm,
            Some<FinishedProduct> fp)
    {
        return new Derivative(name, seller, buyer, price, type, rm,
                Option.<FinishedProduct>some(new FinishedProduct(fp.inner().ip, 
                        ComputeQuality.quality(rm.inner(), fp.inner().ip.assignment))));
    }
}
