/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.evergreen.ir;

import edu.neu.ccs.evergreen.ir.RelationCore;
import edu.neu.ccs.evergreen.ir.RelationI;

public class Relation
implements RelationI {
    private int rank;
    private int relationNumber;

    public Relation(int rank, int relationNumber) {
        RelationCore.checkRank(rank);
        RelationCore.checkRelationNumber(relationNumber, rank);
        this.rank = rank;
        this.relationNumber = relationNumber;
    }

    public int firstForcedVariable(int startPosition) throws IllegalArgumentException {
        return RelationCore.firstForcedVariable(this.relationNumber, this.rank, startPosition);
    }

    public int getMagicNumber(int variablePosition, int value) throws IllegalArgumentException {
        return RelationCore.getMagicNumber(this.rank, variablePosition, value);
    }

    public int getMask() {
        return RelationCore.getMask(this.rank);
    }

    public int getRank() {
        return this.rank;
    }

    public int getRelationNumber() {
        return this.relationNumber;
    }

    public int isForced(int variablePosition) throws IllegalArgumentException {
        return RelationCore.isForced(this.relationNumber, this.rank, variablePosition);
    }

    public boolean isIrrelevant(int variablePosition) throws IllegalArgumentException {
        return RelationCore.isIrrelevant(this.relationNumber, this.rank, variablePosition);
    }

    public int nMap(int variablePosition) throws IllegalArgumentException {
        return RelationCore.nMap(this.relationNumber, this.rank, variablePosition);
    }

    public int numberOfRelevantVariables() {
        return RelationCore.numberOfRelevantVariables(this.relationNumber, this.rank);
    }

    public int ones() {
        return RelationCore.ones(this.relationNumber, this.rank);
    }

    public int q(int s) throws IllegalArgumentException {
        return RelationCore.q(this.relationNumber, this.rank, s);
    }

    public int reduce(int variablePosition, int value) throws IllegalArgumentException {
        return RelationCore.reduce(this.relationNumber, this.rank, variablePosition, value);
    }

    public int renme(int permutationSemantics, int ... permutation) throws IllegalArgumentException {
        return RelationCore.renme(this.relationNumber, this.rank, permutationSemantics, permutation);
    }

    public void setRank(int rank) throws IllegalArgumentException {
        RelationCore.checkRank(rank);
        throw new UnsupportedOperationException();
    }

    public void setRelationNumber(int relationNumber) throws IllegalArgumentException {
        RelationCore.checkRelationNumber(relationNumber, this.rank);
        this.relationNumber = relationNumber;
    }

    public int swap(int variablePosition1, int variablePosition2) throws IllegalArgumentException {
        return RelationCore.swap(this.relationNumber, this.rank, variablePosition1, variablePosition2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationI) {
            RelationI r = (RelationI)obj;
            return r.getRelationNumber() == this.relationNumber;
        }
        return false;
    }

    public String toString() {
        return "" + this.relationNumber;
    }
}

