/*
 * Decompiled with CFR 0.152.
 */
package gen;

import edu.neu.ccs.demeterf.control.Fields;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.Option;
import gen.Assignment;
import gen.Constraint;
import gen.Display;
import gen.ParseException;
import gen.PrintHeap;
import gen.PrintHeapToString;
import gen.Quality;
import gen.SecretOfRawMaterial;
import gen.TheParser;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawMaterialInstance {
    public List<Constraint> cs;
    public Option<SecretOfRawMaterial> secret;

    public RawMaterialInstance(List<Constraint> list, Option<SecretOfRawMaterial> option) {
        this.cs = list;
        this.secret = option;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RawMaterialInstance)) {
            return false;
        }
        RawMaterialInstance rawMaterialInstance = (RawMaterialInstance)object;
        return this.cs.equals(rawMaterialInstance.cs) && this.secret.equals(rawMaterialInstance.secret);
    }

    public static RawMaterialInstance parse(String string) throws ParseException {
        return new TheParser(new StringReader(string)).parse_RawMaterialInstance();
    }

    public static RawMaterialInstance parse(InputStream inputStream) throws ParseException {
        return new TheParser(inputStream).parse_RawMaterialInstance();
    }

    public static RawMaterialInstance parse(Reader reader) throws ParseException {
        return new TheParser(reader).parse_RawMaterialInstance();
    }

    public String printIter() {
        String string = "";
        for (Constraint constraint : this.cs) {
            string = string + constraint.printIter();
        }
        return string;
    }

    public RawMaterialInstance(List<Constraint> list) {
        this(list, (Option<SecretOfRawMaterial>)Option.none());
    }

    public RawMaterialInstance(List<Constraint> list, SecretOfRawMaterial secretOfRawMaterial) {
        this(list, (Option<SecretOfRawMaterial>)Option.some((Object)secretOfRawMaterial));
    }

    public RawMaterialInstance(List<Constraint> list, Assignment assignment2) {
        this(list, new SecretOfRawMaterial((Option<Assignment>)Option.some((Object)assignment2), new Quality(0.0)));
    }

    public RawMaterialInstance addSecret(Assignment assignment2) {
        return new RawMaterialInstance(this.cs, assignment2);
    }

    public RawMaterialInstance addSecretQuality(double d) {
        return new RawMaterialInstance(this.cs, new SecretOfRawMaterial(((SecretOfRawMaterial)this.secret.inner()).assign, new Quality(d)));
    }

    public String display() {
        return Display.DisplayM(this);
    }

    public String print() {
        return PrintHeap.PrintHeapM(this);
    }

    public String toString() {
        return PrintHeapToString.PrintHeapToStringM(this);
    }

    public static class secret
    extends Fields.any {
    }

    public static class cs
    extends Fields.any {
    }
}

