/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import edu.neu.ccs.demeterf.demfgen.classes.RE;
import edu.neu.ccs.demeterf.demfgen.lib.Cons;
import edu.neu.ccs.demeterf.demfgen.lib.Empty;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class List<X>
implements Iterable<X> {
    private final int len;

    public static void main(String[] stringArray) {
        int n2;
        List<Integer> list = List.buildlist(new TestB(), 3000);
        TestC testC = new TestC();
        long l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 20; ++n2) {
            super.mergeSort(testC);
        }
        System.out.println("  Merge: " + (System.currentTimeMillis() - l2));
        l2 = System.currentTimeMillis();
        for (n2 = 0; n2 < 20; ++n2) {
            list.sort(testC);
        }
        System.out.println(" Insert: " + (System.currentTimeMillis() - l2));
    }

    public static <X> List<X> create(X ... XArray) {
        return List.create(XArray, 0);
    }

    public static <X> List<X> create(X[] XArray, int n2) {
        return n2 == XArray.length ? new Empty() : List.create(XArray, n2 + 1).push(XArray[n2]);
    }

    public List(int n2) {
        this.len = n2;
    }

    public List<X> push(X x) {
        return new Cons<X>(x, this);
    }

    public List<X> push(List<X> list) {
        return list.append(this);
    }

    public List<X> reverse() {
        return this.reverse(this.length());
    }

    public List<X> reverse(int n2) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty() && n2-- > 0) {
            X x = list2.top();
            list2 = list2.pop();
            list = list.push(x);
        }
        return list;
    }

    public String toString() {
        return this.toString(" ", "");
    }

    public int index(X x) {
        return this.index(new EqualPred(x));
    }

    public int index(Pred<X> pred) {
        int n2 = 0;
        for (X x : this) {
            if (pred.huh(x)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean same(List<X> list) {
        return this.containsAll(list) && list.containsAll(this);
    }

    public boolean same(List<X> list, Comp<X> comp) {
        return this.containsAll(list, comp) && list.containsAll(this, comp);
    }

    public List<X> pop(int n2) {
        return n2 == 0 ? this : this.pop().pop(n2 - 1);
    }

    public List<X> append(List<X> list) {
        List<X> list2 = this.reverse();
        return super.revpush(list2);
    }

    public List<X> append(X x) {
        return this.append((X)List.create(x));
    }

    public abstract X top();

    public abstract List<X> pop();

    public abstract boolean isEmpty();

    public boolean contains(X x) {
        return this.contains(new EqualPred(x));
    }

    public boolean contains(Pred<X> pred) {
        return this.fold(new OneFold<X>(pred), false);
    }

    public boolean containsAny(List<X> list) {
        return this.containsAny(list, new EqualComp());
    }

    public boolean containsAny(List<X> list, Comp<X> comp) {
        return this.fold(new AnyFold<X>(list, comp), false);
    }

    public boolean containsAll(List<X> list) {
        return this.containsAll(list, new EqualComp());
    }

    public boolean containsAll(List<X> list, Comp<X> comp) {
        return list.fold(new AllFold<X>(this, comp), true);
    }

    public X find(X x) {
        return this.find(new EqualPred(x));
    }

    public X find(Pred<X> pred) {
        for (X x : this) {
            if (!pred.huh(x)) continue;
            return x;
        }
        throw new RE("No Match Found");
    }

    public List<X> remove(X x) {
        return this.remove(new EqualPred(x));
    }

    private List<X> revpush(List<X> list) {
        List<X> list2 = this;
        for (X x : list) {
            list2 = list2.push(x);
        }
        return list2;
    }

    public List<X> remove(Pred<X> pred) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty()) {
            X x = list2.top();
            list2 = list2.pop();
            if (pred.huh(x)) {
                return super.revpush(list);
            }
            list = list.push(x);
        }
        return list.reverse();
    }

    public int length() {
        return this.len;
    }

    public X lookup(int n2) {
        List<X> list = this;
        while (n2-- > 0) {
            list = list.pop();
        }
        return list.top();
    }

    public String toString(String string, String string2) {
        String string3 = "";
        boolean bl = true;
        for (X x : this) {
            if (!bl) {
                string3 = string3 + string;
            } else {
                bl = false;
            }
            string3 = string3 + string2 + x;
        }
        return string3;
    }

    public String toString(Stringer<X> stringer) {
        String string = "";
        List<X> list = this;
        while (!list.isEmpty()) {
            string = string + stringer.toString(list.top(), list.pop());
            list = list.pop();
        }
        return string;
    }

    public List<X> filterout(X x) {
        return this.filterout(new EqualPred(x));
    }

    public List<X> filterout(Pred<X> pred) {
        return this.filter(new NPred(pred));
    }

    public List<X> filter(X x) {
        return this.filter(new EqualPred(x));
    }

    public List<X> filter(Pred<X> pred) {
        List<Object> list = List.create(new Object[0]);
        for (X x : this) {
            if (!pred.huh(x)) continue;
            list = list.push(x);
        }
        return list.reverse();
    }

    public List<X> removeDuplicates() {
        return this.fold(new RMDup(), List.create(new Object[0]));
    }

    public <Y> Y fold(Fold<X, Y> fold, Y y) {
        return this.foldl(fold, y);
    }

    public <Y> Y foldl(Fold<X, Y> fold, Y y) {
        for (X x : this) {
            y = fold.fold(x, y);
        }
        return y;
    }

    public <Y> Y foldr(Fold<X, Y> fold, Y y) {
        return this.reverse().foldl(fold, y);
    }

    public <Y> List<Y> map(Map<X, Y> map) {
        List<Object> list = List.create(new Object[0]);
        for (X x : this.reverse()) {
            list = list.push(map.map(x));
        }
        return list;
    }

    public List<X> add(X x, int n2) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty()) {
            X x2 = list2.top();
            list2 = list2.pop();
            if (n2-- == 0) {
                return super.revpush(list);
            }
            list = list.push(x2);
        }
        throw new RE("Bad Add");
    }

    public List<X> remove(int n2) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty()) {
            X x = list2.top();
            list2 = list2.pop();
            if (n2-- == 0) {
                return super.revpush(list);
            }
            list = list.push(x);
        }
        throw new RE("Bad Remove");
    }

    public List<X> insert(X x, Comp<X> comp) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty()) {
            X x2 = list2.top();
            if (comp.comp(x, x2)) {
                return super.revpush(list);
            }
            list2 = list2.pop();
            list = list.push(x2);
        }
        return list.push(x).reverse();
    }

    public List<X> sort(Comp<X> comp) {
        List<Object> list = List.create(new Object[0]);
        for (X x : this) {
            list = list.insert(x, comp);
        }
        return list;
    }

    public X[] toArray(X[] XArray) {
        int n2 = 0;
        for (X x : this) {
            XArray[n2++] = x;
        }
        return XArray;
    }

    @Override
    public Iterator<X> iterator() {
        return new ListIterator(this);
    }

    public <Y, Z> List<Z> zip(Zip<X, Y, Z> zip, List<Y> list) {
        List<Object> list2 = List.create(new Object[0]);
        List<X> list3 = this;
        while (!list3.isEmpty() && !list.isEmpty()) {
            list2 = list2.push(zip.zip(list3.top(), list.top()));
            list3 = list3.pop();
            list = list.pop();
        }
        return list2.reverse();
    }

    public static <X> List<X> buildlist(Build<X> build, int n2) {
        List<Object> list = List.create(new Object[0]);
        while (n2-- > 0) {
            list = list.push(build.build(n2));
        }
        return list;
    }

    public List<X> replace(int n2, X x) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty()) {
            X x2 = list2.top();
            list2 = list2.pop();
            if (n2-- == 0) {
                return super.revpush(list);
            }
            list = list.push(x2);
        }
        throw new RE("Bad Replace");
    }

    public List<X> replace(X x, X x2) {
        return this.replace(new EqualPred(x), x2);
    }

    public List<X> replace(Pred<X> pred, X x) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty()) {
            X x2 = list2.top();
            list2 = list2.pop();
            if (pred.huh(x2)) {
                return super.revpush(list);
            }
            list = list.push(x2);
        }
        throw new RE("Bad Replace");
    }

    public List<X> replaceAll(X x, X x2) {
        return this.replaceAll(new EqualPred(x), x2);
    }

    public List<X> replaceAll(Pred<X> pred, X x) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (!list2.isEmpty()) {
            X x2 = list2.top();
            list2 = list2.pop();
            list = list.push(pred.huh(x2) ? x : x2);
        }
        return list.reverse();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    private FB<X> frontBack(int n2) {
        List<Object> list = List.create(new Object[0]);
        List<X> list2 = this;
        while (n2-- > 0 && !list2.isEmpty()) {
            list = list.push(list2.top());
            list2 = list2.pop();
        }
        return new FB<Object>(list, list2);
    }

    private static <X> List<X> merge(List<X> list, List<X> list2, Comp<X> comp) {
        List<Object> list3 = List.create(new Object[0]);
        for (X x : list) {
            while (!list2.isEmpty() && comp.comp(list2.top(), x)) {
                list3 = list3.push(list2.top());
                list2 = list2.pop();
            }
            list3 = list3.push(x);
        }
        for (X x : list2) {
            list3 = list3.push(x);
        }
        return list3.reverse();
    }

    private List<X> mergeSort(Comp<X> comp) {
        if (this.length() < 2) {
            return this;
        }
        FB<X> fB = this.frontBack(this.length() / 2);
        return List.merge(super.mergeSort(comp), super.mergeSort(comp), comp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FB<X> {
        List<X> front;
        List<X> back;

        FB(List<X> list, List<X> list2) {
            this.front = list;
            this.back = list2;
        }

        public String toString() {
            return this.front + "::" + this.back;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListIterator<X>
    implements Iterator<X> {
        List<X> inner;

        ListIterator(List<X> list) {
            this.inner = list;
        }

        @Override
        public boolean hasNext() {
            return !this.inner.isEmpty();
        }

        @Override
        public X next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next()");
            }
            X x = this.inner.top();
            this.inner = this.inner.pop();
            return x;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RMDup<X>
    extends Fold<X, List<X>> {
        RMDup() {
        }

        @Override
        public List<X> fold(X x, List<X> list) {
            if (list.contains(x)) {
                return list;
            }
            return list.push(x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AllFold<X>
    extends Fold<X, Boolean> {
        List<X> l;
        Comp<X> c;

        public AllFold(List<X> list, Comp<X> comp) {
            this.l = list;
            this.c = comp;
        }

        @Override
        public Boolean fold(X x, Boolean bl) {
            return bl != false && this.l.contains(this.c.curry(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AnyFold<X>
    extends Fold<X, Boolean> {
        List<X> l;
        Comp<X> c;

        public AnyFold(List<X> list, Comp<X> comp) {
            this.l = list;
            this.c = comp;
        }

        @Override
        public Boolean fold(X x, Boolean bl) {
            return bl != false || this.l.contains(this.c.curry(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OneFold<X>
    extends Fold<X, Boolean> {
        Pred<X> p;

        public OneFold(Pred<X> pred) {
            this.p = pred;
        }

        @Override
        public Boolean fold(X x, Boolean bl) {
            return bl != false || this.p.huh(x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NPred
    extends Pred<X> {
        Pred<X> p;

        NPred(Pred<X> pred) {
            this.p = pred;
        }

        @Override
        public boolean huh(X x) {
            return !this.p.huh(x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EqualComp
    extends Comp<X> {
        private EqualComp() {
        }

        @Override
        public boolean comp(X x, X x2) {
            return x.equals(x2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EqualPred
    extends Pred<X> {
        X which;

        EqualPred(X x) {
            this.which = x;
        }

        @Override
        public boolean huh(X x) {
            return this.which.equals(x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Build<X> {
        public abstract X build(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Zip<X, Y, Z> {
        public abstract Z zip(X var1, Y var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Fold<X, Y> {
        public abstract Y fold(X var1, Y var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Map<X, Y> {
        public abstract Y map(X var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Comp<X> {
        public abstract boolean comp(X var1, X var2);

        public Pred<X> curry(X x) {
            return new Curry<X>(this, x);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Curry<X>
        extends Pred<X> {
            X x;
            Comp<X> c;

            Curry(Comp<X> comp, X x) {
                this.c = comp;
                this.x = x;
            }

            @Override
            public boolean huh(X x) {
                return this.c.comp(this.x, x);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Pred<X> {
        public abstract boolean huh(X var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Stringer<X> {
        public abstract String toString(X var1, List<X> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestC
    extends Comp<Integer> {
        TestC() {
        }

        @Override
        public boolean comp(Integer n2, Integer n3) {
            return n2 < n3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestB
    extends Build<Integer> {
        TestB() {
        }

        @Override
        public Integer build(int n2) {
            return (int)(Math.random() * 100.0);
        }
    }
}

