/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen;

import edu.neu.ccs.demeterf.BuilderAugmentor;
import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.DFGTrav;
import edu.neu.ccs.demeterf.demfgen.DFGTravC;
import edu.neu.ccs.demeterf.demfgen.classes.DemFGenMain;
import edu.neu.ccs.demeterf.demfgen.classes.IncludeList;
import edu.neu.ccs.demeterf.demfgen.classes.StaticTrav;
import edu.neu.ccs.demeterf.demfgen.classes.StaticTravCtx;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefList;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefParams;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.Option;
import edu.neu.ccs.demeterf.parallel.ParTraversal;
import edu.neu.ccs.demeterf.stackless.HeapTrav;

public abstract class Factory {
    static Factory f = new HeapFactory();

    public static DFGTrav newTraversal(BuilderAugmentor builderAugmentor) {
        return f.newTrav(builderAugmentor);
    }

    public static DFGTrav newTraversal(BuilderAugmentor builderAugmentor, Control control) {
        return f.newTrav(builderAugmentor, control);
    }

    public static DFGTravC newTraversalCtx(BuilderAugmentor builderAugmentor) {
        return f.newTravCtx(builderAugmentor);
    }

    public static DFGTravC newTraversalCtx(BuilderAugmentor builderAugmentor, Control control) {
        return f.newTravCtx(builderAugmentor, control);
    }

    public abstract DFGTrav newTrav(BuilderAugmentor var1);

    public abstract DFGTrav newTrav(BuilderAugmentor var1, Control var2);

    public abstract DFGTravC newTravCtx(BuilderAugmentor var1);

    public abstract DFGTravC newTravCtx(BuilderAugmentor var1, Control var2);

    static class STravC
    extends StaticTravCtx
    implements DFGTravC {
        STravC(BuilderAugmentor builderAugmentor) {
            super(builderAugmentor);
        }

        STravC(BuilderAugmentor builderAugmentor, Control control) {
            super(builderAugmentor, control);
        }
    }

    static class STrav
    extends StaticTrav
    implements DFGTrav {
        STrav(BuilderAugmentor builderAugmentor) {
            super(builderAugmentor);
        }

        STrav(BuilderAugmentor builderAugmentor, Control control) {
            super(builderAugmentor, control);
        }
    }

    static class HTrav
    extends Trav {
        HTrav(BuilderAugmentor builderAugmentor) {
            super(new HeapTrav(builderAugmentor));
        }

        HTrav(BuilderAugmentor builderAugmentor, Control control) {
            super(new HeapTrav(builderAugmentor, control));
        }
    }

    static class PTrav
    extends Trav {
        PTrav(BuilderAugmentor builderAugmentor) {
            super(new ParTraversal(builderAugmentor));
        }

        PTrav(BuilderAugmentor builderAugmentor, Control control) {
            super(new ParTraversal(builderAugmentor, control));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Trav
    implements DFGTrav,
    DFGTravC {
        Traversal trav;

        Trav(BuilderAugmentor builderAugmentor) {
            this(new Traversal(builderAugmentor));
        }

        Trav(BuilderAugmentor builderAugmentor, Control control) {
            this(new Traversal(builderAugmentor, control));
        }

        Trav(Traversal traversal) {
            this.trav = traversal;
        }

        @Override
        public <Ret> Ret traverseList_DemFGenMain_(List<DemFGenMain> list) {
            return this.trav.traverse(list);
        }

        @Override
        public <Ret> Ret traverseTypeDefParams(TypeDefParams typeDefParams) {
            return this.trav.traverse(typeDefParams);
        }

        @Override
        public <Ret> Ret traverseTypeDefList(TypeDefList typeDefList) {
            return this.trav.traverse(typeDefList);
        }

        @Override
        public <Ret> Ret traverseList_TypeDef_(List<TypeDef> list) {
            return this.trav.traverse(list);
        }

        @Override
        public <Ret> Ret traverseOption_List_TypeDef__(Option<List<TypeDef>> option) {
            return this.trav.traverse(option);
        }

        @Override
        public <Ret> Ret traverseTypeDef(TypeDef typeDef) {
            return this.trav.traverse(typeDef);
        }

        @Override
        public <Ret> Ret traverseIncludeList(IncludeList includeList) {
            return this.trav.traverse(includeList);
        }

        @Override
        public <Ret> Ret traverseList_DemFGenMain_(List<DemFGenMain> list, Object object) {
            return this.trav.traverse(list, object);
        }

        @Override
        public <Ret> Ret traverseTypeDefList(TypeDefList typeDefList, Object object) {
            return this.trav.traverse((Object)typeDefList, object);
        }

        @Override
        public <Ret> Ret traverseTypeDef(TypeDef typeDef, Object object) {
            return this.trav.traverse((Object)typeDef, object);
        }
    }

    private static class HeapFactory
    extends Factory {
        private HeapFactory() {
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor) {
            return new HTrav(builderAugmentor);
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor, Control control) {
            return new HTrav(builderAugmentor, control);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor) {
            return new HTrav(builderAugmentor);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor, Control control) {
            return new HTrav(builderAugmentor, control);
        }
    }

    private static class ParFactory
    extends Factory {
        private ParFactory() {
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor) {
            return new PTrav(builderAugmentor);
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor, Control control) {
            return new PTrav(builderAugmentor, control);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor) {
            return new PTrav(builderAugmentor);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor, Control control) {
            return new PTrav(builderAugmentor, control);
        }
    }

    private static class StaticFactory
    extends Factory {
        private StaticFactory() {
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor) {
            return new STrav(builderAugmentor);
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor, Control control) {
            return new STrav(builderAugmentor, control);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor) {
            return new STravC(builderAugmentor);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor, Control control) {
            return new STravC(builderAugmentor, control);
        }
    }

    private static class DynFactory
    extends Factory {
        private DynFactory() {
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor) {
            return new Trav(builderAugmentor);
        }

        public DFGTrav newTrav(BuilderAugmentor builderAugmentor, Control control) {
            return new Trav(builderAugmentor, control);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor) {
            return new Trav(builderAugmentor);
        }

        public DFGTravC newTravCtx(BuilderAugmentor builderAugmentor, Control control) {
            return new Trav(builderAugmentor, control);
        }
    }
}

