/*
 * Decompiled with CFR 0.152.
 */
package utils;

import gen.Assignment;
import gen.Constraint;
import gen.Derivative;
import gen.FinishedProduct;
import gen.History;
import gen.IntermediateProduct;
import gen.Literal;
import gen.Pair;
import gen.PlayerID;
import gen.PlayerStore;
import gen.PlayerTransaction;
import gen.RawMaterial;
import gen.RawMaterialInstance;
import gen.Round;
import gen.Store;
import gen.Transaction;
import gen.Type;
import gen.TypeInstance;
import gen.Variable;

public class Printer {
    public static String printIter(IntermediateProduct intermediateProduct) {
        return "(assignment:" + Printer.printIter(intermediateProduct.assignment) + ")";
    }

    public static String printIter(RawMaterialInstance rawMaterialInstance) {
        String string = "";
        for (Constraint constraint : rawMaterialInstance.cs) {
            string = string + Printer.printIter(constraint);
        }
        return string;
    }

    public static String printIter(Constraint constraint) {
        String string = "\n";
        string = string + constraint.w.print() + constraint.r.print();
        for (Variable variable : constraint.vs) {
            string = string + variable.print();
        }
        return string;
    }

    public static String printIter(Assignment assignment) {
        String string = "[";
        for (Literal literal : assignment.literals) {
            string = string + literal.print();
        }
        string = string + "]";
        return string;
    }

    public static String printIter(Type type) {
        String string = "type[";
        for (TypeInstance typeInstance : type.instances) {
            string = string + typeInstance.print();
        }
        return string + "]";
    }

    public static String printIter(Derivative derivative) {
        String string = "deriv[";
        string = string + "\"" + derivative.name + "\" " + derivative.seller.print() + " ";
        string = string + (derivative.optbuyer.isSome() ? ((PlayerID)derivative.optbuyer.inner()).print() : "");
        string = string + " " + derivative.price.print() + " " + derivative.type.print() + " ";
        string = string + (derivative.optraw.isSome() ? Printer.printIter((RawMaterial)derivative.optraw.inner()) : "");
        string = string + " " + (derivative.optfinished.isSome() ? ((FinishedProduct)derivative.optfinished.inner()).print() : "");
        return string + "]";
    }

    public static String printIter(RawMaterial rawMaterial) {
        return "rm[" + Printer.printIter(rawMaterial.instance) + "]";
    }

    public static String printIter(FinishedProduct finishedProduct) {
        return "finish[" + Printer.printIter(finishedProduct.ip) + " " + finishedProduct.quality.print() + "]";
    }

    public static String printIter(History history) {
        String string = "history[\n";
        for (Round round : history.rounds) {
            string = string + Printer.printIter(round);
        }
        return string + "]";
    }

    public static String printIter(Round round) {
        String string = "\nround " + round.num + " [";
        for (PlayerTransaction playerTransaction : round.ptransactions) {
            string = string + Printer.printIter(playerTransaction);
        }
        return string + "]";
    }

    public static String printIter(PlayerTransaction playerTransaction) {
        String string = "ptrans[ player ";
        string = string + playerTransaction.player.print();
        for (Transaction transaction : playerTransaction.transactions) {
            string = string + Printer.printIter(transaction);
        }
        return string + "]";
    }

    public static String printIter(Transaction transaction) {
        return "\ntrans[" + transaction.ttype.print() + " " + Printer.printIter(transaction.deriv) + "]";
    }

    public static String printIter(Store store) {
        String string = "store[";
        for (Pair pair : store.stores) {
            string = string + ((PlayerID)pair.a).print() + Printer.printIter((PlayerStore)pair.b);
        }
        return string + "]";
    }

    public static String printIter(PlayerStore playerStore) {
        String string = "pstore forsale ";
        for (Derivative derivative : playerStore.forSale) {
            string = string + Printer.printIter(derivative);
        }
        string = string + " bought ";
        for (Derivative derivative : playerStore.bought) {
            string = string + Printer.printIter(derivative);
        }
        return string;
    }
}

