/*
 * Decompiled with CFR 0.152.
 */
package admin.hidden;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.evergreen.ir.Relation;
import gen.Assignment;
import gen.Constraint;
import gen.Literal;
import gen.Quality;
import gen.RawMaterial;
import gen.RawMaterialInstance;
import gen.RelationNr;

public class ComputeQuality {
    public static Quality quality(RawMaterial rawMaterial, Assignment assignment) {
        RawMaterial rawMaterial2 = assignment.literals.fold(new List.Fold<Literal, RawMaterial>(){

            @Override
            public RawMaterial fold(Literal literal, RawMaterial rawMaterial) {
                return ComputeQuality.reduce(rawMaterial, literal);
            }
        }, rawMaterial);
        return new Quality(ComputeQuality.satisfiedRatio(rawMaterial2));
    }

    public static RawMaterial reduce(RawMaterial rawMaterial, final Literal literal) {
        return new RawMaterial(new RawMaterialInstance(rawMaterial.instance.cs.map(new List.Map<Constraint, Constraint>(){

            @Override
            public Constraint map(Constraint constraint) {
                int n = constraint.vs.index(literal.var);
                if (n < 0 || constraint.r.v == 255) {
                    return constraint;
                }
                return new Constraint(constraint.w, new RelationNr(new Relation(3, constraint.r.v).reduce(n, literal.value.sign())), constraint.vs);
            }
        })));
    }

    public static double satisfiedRatio(RawMaterial rawMaterial) {
        return rawMaterial.instance.cs.fold(new List.Fold<Constraint, R>(){

            @Override
            public R fold(Constraint constraint, R r) {
                return r.add(constraint.r.v == 255 ? constraint.w.v : 0, constraint.w.v);
            }
        }, new R(0.0, 0.0)).result();
    }

    static class R {
        double top;
        double bot;

        R(double d, double d2) {
            this.top = d;
            this.bot = d2;
        }

        R add(int n, int n2) {
            return new R(this.top + (double)n, this.bot + (double)n2);
        }

        double result() {
            return this.bot == 0.0 ? 1.0 : this.top / this.bot;
        }
    }
}

