/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.utils.SetQualities;
import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import gen.Buy;
import gen.Create;
import gen.Deliver;
import gen.Derivative;
import gen.Finish;
import gen.FinishedProduct;
import gen.Pair;
import gen.PlayerID;
import gen.PlayerStore;
import gen.PlayerTransaction;
import gen.RawMaterial;
import gen.Reoffer;
import gen.Store;
import gen.Transaction;
import utils.DerivativesFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static void _print(String string) {
        System.err.println(string);
    }

    public static Pair<PlayerID, Double> pair(PlayerID playerID, Double d) {
        return new Pair((Object)playerID, (Object)d);
    }

    public static Pair<PlayerID, PlayerStore> spair(PlayerID playerID, PlayerStore playerStore) {
        return new Pair((Object)playerID, (Object)playerStore);
    }

    public static PlayerTransaction computeQualities(PlayerTransaction playerTransaction) {
        return SetQualities.setQs(playerTransaction, Control.builtins(Derivative.class));
    }

    public static PlayerTransaction truncateRMs(PlayerTransaction playerTransaction, final int n) {
        return new PlayerTransaction(playerTransaction.player, playerTransaction.transactions.map(new List.Map<Transaction, Transaction>(){

            @Override
            public Transaction map(Transaction transaction) {
                return new Transaction(transaction.ttype, transaction.deriv.truncateRM(n));
            }
        }));
    }

    public static PlayerTransaction checkDerivatives(PlayerTransaction playerTransaction, Store store) {
        final List<Derivative> list = DerivativesFinder.findActiveDers(store.stores);
        return new PlayerTransaction(playerTransaction.player, playerTransaction.transactions.map(new List.Map<Transaction, Transaction>(){

            @Override
            public Transaction map(Transaction transaction) {
                if (transaction.ttype instanceof Create || !list.contains(new Which(transaction.deriv))) {
                    return transaction;
                }
                Derivative derivative = list.find(new Which(transaction.deriv));
                if (!(transaction.ttype instanceof Buy)) {
                    if (transaction.ttype instanceof Reoffer) {
                        derivative = transaction.deriv;
                    } else if (transaction.ttype instanceof Deliver) {
                        derivative = list.find(new PreDeliver(transaction.deriv));
                        derivative = derivative.deliver(((RawMaterial)transaction.deriv.optraw.inner()).instance);
                    } else if (transaction.ttype instanceof Finish) {
                        derivative = list.find(new PreFinish(transaction.deriv));
                        derivative = derivative.finish((FinishedProduct)transaction.deriv.optfinished.inner());
                    }
                }
                return new Transaction(transaction.ttype, derivative);
            }
        }));
    }

    static class PreFinish
    extends Which {
        PreFinish(Derivative derivative) {
            super(derivative);
        }

        public boolean huh(Derivative derivative) {
            return super.huh(derivative) && derivative.optbuyer.isSome() && derivative.optbuyer.equals(this.forwrd.optbuyer) && derivative.optraw.isSome() && !derivative.optfinished.isSome();
        }
    }

    static class PreDeliver
    extends Which {
        PreDeliver(Derivative derivative) {
            super(derivative);
        }

        public boolean huh(Derivative derivative) {
            return super.huh(derivative) && derivative.optbuyer.isSome() && derivative.optbuyer.equals(this.forwrd.optbuyer) && !derivative.optraw.isSome();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Which
    extends List.Pred<Derivative> {
        Derivative forwrd;

        Which(Derivative derivative) {
            this.forwrd = derivative;
        }

        @Override
        public boolean huh(Derivative derivative) {
            return derivative.name.equals(this.forwrd.name) && derivative.price.equals((Object)this.forwrd.price) && derivative.seller.equals((Object)this.forwrd.seller) && derivative.type.equals((Object)this.forwrd.type);
        }
    }
}

