/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.perform;

import edu.neu.ccs.demeterf.Builder;
import edu.neu.ccs.demeterf.BuilderAugmentor;
import edu.neu.ccs.demeterf.Control;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.perform.Traversal;
import edu.neu.ccs.demeterf.util.Option;
import edu.neu.ccs.demeterf.util.Util;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapTrav
extends Traversal {
    public HeapTrav(BuilderAugmentor builderAugmentor) {
        super(builderAugmentor);
    }

    public HeapTrav(Builder builder) {
        super(builder);
    }

    public HeapTrav(ID iD) {
        super(iD);
    }

    public HeapTrav(BuilderAugmentor builderAugmentor, Control control) {
        super(builderAugmentor, control);
    }

    public HeapTrav(Builder builder, Control control) {
        super(builder, control);
    }

    public HeapTrav(ID iD, Control control) {
        super(iD, control);
    }

    @Override
    protected <Ret> Ret traverse(Object object, Option option) {
        Cont cont = new Hole(object, option);
        while (!((Cont)cont).isValue()) {
            cont = ((Cont)cont).step();
        }
        return (Ret)((Value)cont).val;
    }

    public class Value
    extends Cont {
        final Object val;

        public Value(Object object) {
            this.val = object;
        }

        public boolean isValue() {
            return true;
        }

        public Cont apply(Value value) {
            throw new RuntimeException("Cannot Apply a Value to a Value");
        }

        public Cont step() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjCont
    extends Hole {
        final List<Object> results;
        final List<Field> left;

        public ObjCont(Object object, Option option, List<Object> list, List<Field> list2, Cont cont) {
            super(object, option, cont);
            this.results = list;
            this.left = list2;
        }

        @Override
        public Cont apply(Value value) {
            return new ObjCont(this.prev, this.targ, this.results.push(value.val), this.left.pop(), this.link);
        }

        @Override
        public Cont step() {
            if (this.left.isEmpty()) {
                List<Object> list = this.results.reverse().push(this.prev);
                return this.link.apply(this.dispatch(list.toArray((Object[])new Object[list.length()]), this.targ, false));
            }
            Field field = this.left.top();
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                Object object = field.get(this.prev);
                if (HeapTrav.this.control.skip(this.prev.getClass(), field.getName())) {
                    return this.apply(new Value(object));
                }
                Option option = this.targ.some() ? HeapTrav.this.applyAugment(new Object[]{this.prev, this.targ.get()}, field) : this.targ;
                return new Hole(object, option, this);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }

    class Hole
    extends Cont {
        final Object prev;
        final Option targ;
        final Cont link;

        public Hole(Object object, Option option) {
            this.prev = object;
            this.targ = option;
            this.link = this;
        }

        public Hole(Object object, Option option, Cont cont) {
            this.prev = object;
            this.targ = option;
            this.link = cont;
        }

        public boolean isValue() {
            return false;
        }

        public Cont apply(Value value) {
            return this == this.link ? value : this.link.apply(value);
        }

        public Cont step() {
            if (HeapTrav.this.control.isBuiltIn(this.prev.getClass())) {
                return this.apply(this.dispatch(new Object[]{this.prev}, this.targ, true));
            }
            return new ObjCont(this.prev, this.targ, List.create(new Object[0]), Util.getFuncFields(this.prev.getClass()), this);
        }

        public Value dispatch(Object[] objectArray, Option option, boolean bl) {
            return new Value(HeapTrav.this.applyBuilder(Util.addArg(objectArray, option), bl));
        }
    }

    static abstract class Cont {
        Cont() {
        }

        public abstract boolean isValue();

        public abstract Cont apply(Value var1);

        public abstract Cont step();
    }
}

