/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import edu.neu.ccs.demeterf.control.Fields;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.RBTree;
import edu.neu.ccs.demeterf.demfgen.lib.Wrap;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Set<X>
implements Iterable<X> {
    public final RBTree<Wrap<X>> tree;
    private final Comparator<X> comp;

    private Set() {
        this((Comparator<X>)new CComp(), RBTree.create((Comparable[])new Wrap[0]));
    }

    private Set(Comparator<X> comparator) {
        this(comparator, RBTree.create((Comparable[])new Wrap[0]));
    }

    private Set(List<X> list, final Comparator<X> comparator) {
        this(comparator, RBTree.create(list.map(new List.Map<X, Wrap<X>>(){

            @Override
            public Wrap<X> map(X x) {
                return new Wrap(x, comparator);
            }
        })));
    }

    public Set(List<X> list) {
        this(list, new CComp());
    }

    public Set(X ... XArray) {
        this(List.create(XArray), new CComp());
    }

    public Set(Comparator<X> comparator, X ... XArray) {
        this(List.create(XArray), comparator);
    }

    public Set(RBTree<Wrap<X>> rBTree) {
        this((Comparator<X>)new Wrap.CComp(), rBTree);
    }

    public static <X extends Comparable<X>> Set<X> create() {
        return new Set<X>();
    }

    public static <X> Set<X> create(Comparator<X> comparator) {
        return new Set<X>(comparator, RBTree.create((Comparable[])new Wrap[0]));
    }

    public static <X extends Comparable<X>> Set<X> create(List<X> list) {
        return new Set<X>(list);
    }

    public static <X> Set<X> create(List<X> list, Comparator<X> comparator) {
        return new Set<X>(list, comparator);
    }

    public static <X extends Comparable<X>> Set<X> create(X ... XArray) {
        return new Set<X>(List.create(XArray));
    }

    private Set(Comparator<X> comparator, List<Wrap<X>> list) {
        this(comparator, RBTree.create(list));
    }

    private Set(Comparator<X> comparator, RBTree<Wrap<X>> rBTree) {
        this.tree = rBTree;
        this.comp = comparator;
    }

    private Set<X> make(RBTree<Wrap<X>> rBTree) {
        return new Set<X>(this.comp, rBTree);
    }

    private Set<X> make(List<Wrap<X>> list) {
        return new Set<X>(this.comp, list);
    }

    private List<Wrap<X>> toWrapList() {
        return this.tree.toList();
    }

    public boolean contains(X x) {
        return this.tree.contains(new Wrap<X>(x, this.comp));
    }

    public boolean isEmpty() {
        return this.tree.isLeaf();
    }

    public Set<X> add(X x) {
        return this.make(this.tree.insert(new Wrap<X>(x, this.comp)));
    }

    public Set<X> remove(X x) {
        return this.make(this.tree.remove(new Wrap<X>(x, this.comp)));
    }

    public boolean subseteq(Set<X> set) {
        return set.tree.containsAll(this.tree);
    }

    public Set<X> union(Set<X> set) {
        return this.make(this.tree.insertAll(set.tree));
    }

    public Set<X> intersect(final Set<X> set) {
        return this.make(this.toWrapList().filter(new List.Pred<Wrap<X>>(){

            @Override
            public boolean huh(Wrap<X> wrap) {
                return set.tree.contains(wrap);
            }
        }));
    }

    public Set<X> difference(final Set<X> set) {
        return this.make(this.toWrapList().filter(new List.Pred<Wrap<X>>(){

            @Override
            public boolean huh(Wrap<X> wrap) {
                return !set.tree.contains(wrap);
            }
        }));
    }

    public List<X> toList() {
        return this.toWrapList().map(new List.Map<Wrap<X>, X>(){

            @Override
            public X map(Wrap<X> wrap) {
                return wrap.x;
            }
        });
    }

    @Override
    public Iterator<X> iterator() {
        return this.toList().iterator();
    }

    public Set<X> merge(Set<X> set, final Merge<X> merge) {
        return this.make(super.toWrapList().fold(new List.Fold<Wrap<X>, RBTree<Wrap<X>>>(){

            @Override
            public RBTree<Wrap<X>> fold(Wrap<X> wrap, RBTree<Wrap<X>> rBTree) {
                if (!rBTree.contains(wrap)) {
                    return rBTree.insert(wrap);
                }
                return rBTree.replace(new Wrap(merge.merge(wrap.x, rBTree.find(wrap).x), Set.this.comp));
            }
        }, this.tree));
    }

    public Set<X> merge(X x, Merge<X> merge) {
        Wrap<X> wrap = new Wrap<X>(x, this.comp);
        if (!this.tree.contains(wrap)) {
            return this.make(this.tree.insert(wrap));
        }
        return this.make(this.tree.replace(new Wrap<X>(merge.merge(x, this.tree.find(wrap).x), this.comp)));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        return set.tree.containsAll(this.tree) && this.tree.containsAll(set.tree);
    }

    public String toString() {
        return "{ " + this.toList().toString(" ", "") + " }";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CComp<X>
    implements Comparator<X> {
        private CComp() {
        }

        @Override
        public int compare(X x, X x2) {
            return ((Comparable)x).compareTo(x2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Merge<X> {
        public abstract X merge(X var1, X var2);
    }

    public static class tree
    extends Fields.any {
    }
}

